/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.management.ManagementRuntimeException;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.management.ServerLocatorDescriptor;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ServerLocatorService
extends DefaultComponent
implements ServerLocator {
    public static final String LOCATORS_EXT_KEY = "locators";
    private static final Log log = LogFactory.getLog(ServerLocatorService.class);
    protected Map<String, MBeanServer> otherServers = new HashMap<String, MBeanServer>();
    protected MBeanServer defaultServer = ManagementFactory.getPlatformMBeanServer();
    protected String hostname;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(LOCATORS_EXT_KEY)) {
            this.doRegisterLocator((ServerLocatorDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(LOCATORS_EXT_KEY)) {
            this.doUnregisterLocator((ServerLocatorDescriptor)contribution);
        }
    }

    protected void doRegisterLocator(ServerLocatorDescriptor descriptor) {
        MBeanServer server = descriptor.isExisting ? this.doFindServer(descriptor) : this.doCreateServer(descriptor);
        this.otherServers.put(descriptor.domainName, server);
        if (descriptor.isDefault) {
            this.defaultServer = server;
        }
    }

    protected String doGetHostname() {
        if (this.hostname != null) {
            return this.hostname;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            this.hostname = "localhost";
        }
        return this.hostname;
    }

    protected JMXServiceURL doFormatServerURL(ServerLocatorDescriptor descriptor) {
        try {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + descriptor.rmiPort + "/" + descriptor.domainName + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            throw new ManagementRuntimeException("Cannot format url for " + descriptor.domainName);
        }
    }

    protected String doFormatThreadName(ServerLocatorDescriptor descriptor) {
        return "mbeanServer-" + descriptor.domainName;
    }

    protected MBeanServer doCreateServer(ServerLocatorDescriptor descriptor) {
        RMIConnectorServer connector;
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        JMXServiceURL url = this.doFormatServerURL(descriptor);
        try {
            connector = new RMIConnectorServer(url, null, server);
        }
        catch (IOException e) {
            throw new ManagementRuntimeException("Cannot start connector for " + descriptor.domainName, e);
        }
        try {
            connector.start();
        }
        catch (IOException e) {
            try {
                LocateRegistry.createRegistry(descriptor.rmiPort);
            }
            catch (Exception e2) {
                throw new ManagementRuntimeException("Cannot start RMI connector for " + descriptor.domainName, e);
            }
            try {
                connector.start();
            }
            catch (Exception e2) {
                throw new ManagementRuntimeException("Cannot start RMI connector for " + descriptor.domainName, e2);
            }
        }
        assert (connector.isActive());
        return server;
    }

    protected MBeanServer doFindServer(ServerLocatorDescriptor descriptor) {
        String domainName = descriptor.domainName;
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            String domain = server.getDefaultDomain();
            if (domain == null || !domain.equals(domainName)) continue;
            return server;
        }
        throw new ManagementRuntimeException("cannot locate mbean server containing domain " + domainName);
    }

    protected void doUnregisterLocator(ServerLocatorDescriptor descriptor) {
        this.otherServers.remove(descriptor.domainName);
        if (descriptor.isDefault) {
            this.defaultServer = ManagementFactory.getPlatformMBeanServer();
        }
    }

    public MBeanServer lookupServer(ObjectName qualifiedName) {
        if (this.defaultServer.isRegistered(qualifiedName)) {
            return this.defaultServer;
        }
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.isRegistered(qualifiedName)) continue;
            return server;
        }
        throw new ManagementRuntimeException(qualifiedName + " is not registered");
    }

    public MBeanServer lookupServer() {
        return this.defaultServer;
    }

    public MBeanServer lookupServer(String domainName) {
        if (this.otherServers.containsKey(domainName)) {
            return this.otherServers.get(domainName);
        }
        return this.defaultServer;
    }

    public void registerLocator(String domain, boolean isDefault) {
        this.doRegisterLocator(new ServerLocatorDescriptor(domain, isDefault));
    }
}

