/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.nuxeo.runtime.management.ManagementRuntimeException;
import org.nuxeo.runtime.model.ComponentName;

public class ObjectNameFactory {
    public static final String NUXEO_DOMAIN_NAME = "org.nuxeo";
    private static final Pattern namePattern = Pattern.compile(".*:.*");
    private static final Pattern avaPattern = Pattern.compile(".*=.*");

    private ObjectNameFactory() {
    }

    public static String formatQualifiedName(String domainName, String typeName, String instanceName) {
        int lastDotIndex = instanceName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String packageName = instanceName.substring(0, lastDotIndex);
            instanceName = instanceName.substring(lastDotIndex + 1);
            return ObjectNameFactory.formatQualifiedName(domainName, typeName, packageName, instanceName);
        }
        return String.format("%s:name=%s,type=%s", domainName, instanceName, typeName);
    }

    public static String formatQualifiedName(String domainName, String typeName, String packageName, String instanceName) {
        return String.format("%s:package=%s,name=%s,type=%s", domainName, packageName, instanceName, typeName);
    }

    public static String formatQualifiedName(String typeName, String instanceName) {
        return ObjectNameFactory.formatQualifiedName(NUXEO_DOMAIN_NAME, typeName, instanceName);
    }

    public static String formatQualifiedName(ComponentName componentName) {
        return ObjectNameFactory.formatQualifiedName(componentName.getType(), componentName.getName());
    }

    public static String formatQualifiedName(String instanceName) {
        return ObjectNameFactory.formatQualifiedName("service", instanceName);
    }

    public static String formatMetricQualifiedName(ComponentName name, String metricName) {
        return ObjectNameFactory.formatQualifiedName(name) + ",metric=" + metricName + ",management=metric";
    }

    public static String formatAVAs(String ... avas) {
        StringBuffer buffer = new StringBuffer();
        for (String ava : avas) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(ava);
        }
        return buffer.toString();
    }

    public static String formatMetricQualifiedName(ComponentName name, String metricName, String ... avas) {
        return ObjectNameFactory.formatQualifiedName(name) + ",metric=" + metricName + "," + ObjectNameFactory.formatAVAs(avas) + ",management=metric";
    }

    public static String formatInventoryQualifiedName(ComponentName name) {
        return ObjectNameFactory.formatQualifiedName(name) + ",management=inventory";
    }

    public static String formatProbeQualifiedName(ComponentName name) {
        return ObjectNameFactory.formatQualifiedName(name) + ",management=probe";
    }

    public static String removeDotPart(String name) {
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos != -1) {
            name = name.substring(lastDotPos + 1);
        }
        return name;
    }

    public static String formatShortName(ObjectName name) {
        String shortName = ObjectNameFactory.removeDotPart(name.getKeyProperty("name"));
        String typeName = name.getKeyProperty("type");
        if (!typeName.equals("service")) {
            shortName = shortName + "-" + typeName;
        }
        Hashtable<String, String> keys = name.getKeyPropertyList();
        for (Map.Entry keyEntry : keys.entrySet()) {
            String key = (String)keyEntry.getKey();
            String value = (String)keyEntry.getValue();
            if (key.equals("name") || key.equals("type") && value.equals("service")) continue;
            shortName = shortName + "-" + (String)keyEntry.getValue();
        }
        return shortName;
    }

    public static String formatShortName(String name) {
        ObjectName objectName = ObjectNameFactory.getObjectName(name);
        return ObjectNameFactory.formatShortName(objectName);
    }

    public static String formatTypeQuery(String typeName) {
        return ObjectNameFactory.formatTypeQuery(NUXEO_DOMAIN_NAME, typeName);
    }

    public static String formatTypeQuery(String domainName, String typeName) {
        return String.format("%s:type=%s,*", domainName, typeName);
    }

    public static boolean hasDomain(String value) {
        Matcher matcher = namePattern.matcher(value);
        return matcher.matches();
    }

    public static boolean hasAttributeValueAssertion(String value) {
        Matcher matcher = avaPattern.matcher(value);
        return matcher.matches();
    }

    public static boolean isQualified(String name) {
        return ObjectNameFactory.hasDomain(name) && ObjectNameFactory.hasAttributeValueAssertion(name);
    }

    public static String getQualifiedName(String name) {
        String qualifiedName = name;
        if (!ObjectNameFactory.hasAttributeValueAssertion(qualifiedName)) {
            qualifiedName = "org.nuxeo:name=" + name + ",type=service";
        } else if (!ObjectNameFactory.hasDomain(qualifiedName)) {
            qualifiedName = "org.nuxeo:" + qualifiedName;
        }
        return qualifiedName;
    }

    public static ObjectName getObjectName(String name) {
        String qualifiedName = ObjectNameFactory.getQualifiedName(name);
        try {
            return new ObjectName(qualifiedName);
        }
        catch (Exception e) {
            throw ManagementRuntimeException.wrap(name + " is not correct", e);
        }
    }

    public static ObjectName getObjectName(String name, String avas) {
        String qualifiedName = ObjectNameFactory.getQualifiedName(name) + "," + avas;
        try {
            return new ObjectName(qualifiedName);
        }
        catch (Exception e) {
            throw ManagementRuntimeException.wrap(name + " is not correct", e);
        }
    }

    public static String formatMetricShortName(String name) {
        return name + "-metric";
    }

    public static String formatInventoryShortName(String name) {
        return name + "-inventory";
    }

    public static String formatProbeShortName(String name) {
        return name + "-probe";
    }
}

