/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.ContainerBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.FrameworkBootstrap;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.NuxeoWebappLoader;
import org.nuxeo.runtime.tomcat.dev.DevFrameworkBootstrap;
import org.nuxeo.runtime.tomcat.dev.NuxeoDevWebappClassLoader;

public class NuxeoLauncher
implements LifecycleListener {
    public static final String DEV_BUNDLES_NAME = "org.nuxeo:type=sdk,name=dev-bundles";
    public static final String WEB_RESOURCES_NAME = "org.nuxeo:type=sdk,name=web-resources";
    static final Log log = LogFactory.getLog(NuxeoLauncher.class);
    protected boolean shared;
    protected String home = "nxserver";
    protected boolean automaticReload = true;
    protected FrameworkBootstrap bootstrap;

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getHome() {
        return this.home;
    }

    public void setAutomaticReload(boolean value) {
        this.automaticReload = value;
    }

    public boolean getAutomaticReload() {
        return this.automaticReload;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Loader loader;
        Lifecycle lf = event.getLifecycle();
        if (lf instanceof ContainerBase && (loader = ((Container)lf).getLoader()) instanceof NuxeoWebappLoader) {
            this.handleEvent((NuxeoWebappLoader)loader, event);
        }
    }

    protected void handleEvent(NuxeoWebappLoader loader, LifecycleEvent event) {
        try {
            MutableClassLoader cl = (MutableClassLoader)((Object)loader.getClassLoader());
            boolean devMode = cl instanceof NuxeoDevWebappClassLoader;
            String type = event.getType();
            if (type == "start") {
                File homeDir = this.resolveHomeDirectory(loader);
                if (devMode) {
                    this.bootstrap = new DevFrameworkBootstrap(cl, homeDir);
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    server.registerMBean(this.bootstrap, new ObjectName(DEV_BUNDLES_NAME));
                    server.registerMBean(cl, new ObjectName(WEB_RESOURCES_NAME));
                    ((NuxeoDevWebappClassLoader)cl).setBootstrap((DevFrameworkBootstrap)this.bootstrap);
                } else {
                    this.bootstrap = new FrameworkBootstrap(cl, homeDir);
                }
                this.bootstrap.setHostName("Tomcat");
                this.bootstrap.setHostVersion("6.0.20");
                this.bootstrap.initialize();
            } else if (type == "after_start") {
                this.bootstrap.start();
            } else if (type == "stop") {
                this.bootstrap.stop();
                if (devMode) {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    server.unregisterMBean(new ObjectName(DEV_BUNDLES_NAME));
                    server.unregisterMBean(new ObjectName(WEB_RESOURCES_NAME));
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to handle event", e);
        }
    }

    protected File resolveHomeDirectory(NuxeoWebappLoader loader) {
        String path = null;
        if (this.home.startsWith("/") || this.home.startsWith("\\") || this.home.contains(":/") || this.home.contains(":\\")) {
            path = this.home;
        } else if (this.home.startsWith("${catalina.base}")) {
            path = this.getTomcatHome() + this.home.substring("${catalina.base}".length());
        } else {
            try {
                File baseDir = loader.getBaseDir();
                return new File(baseDir, this.home);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return new File(path);
    }

    public String getTomcatHome() {
        String tomcatHome = System.getProperty("catalina.base");
        if (tomcatHome == null) {
            tomcatHome = System.getProperty("catalina.home");
        }
        return tomcatHome;
    }
}

