/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.File;
import java.lang.reflect.Method;
import org.nuxeo.runtime.tomcat.dev.DevBundle;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;

public class ReloadServiceInvoker {
    protected Object reloadService;
    protected Method deployBundle;
    protected Method undeployBundle;
    protected Method runDeploymentPreprocessor;
    protected Method installWebResources;
    protected Method flush;
    protected Method reload;
    protected Method flushSeam;
    protected Method reloadSeam;

    public ReloadServiceInvoker(ClassLoader cl) throws Exception {
        Class<?> frameworkClass = cl.loadClass("org.nuxeo.runtime.api.Framework");
        Class<?> reloadServiceClass = cl.loadClass("org.nuxeo.runtime.reload.ReloadService");
        Method getLocalService = frameworkClass.getDeclaredMethod("getLocalService", Class.class);
        this.reloadService = getLocalService.invoke(null, reloadServiceClass);
        this.deployBundle = reloadServiceClass.getDeclaredMethod("deployBundle", File.class);
        this.undeployBundle = reloadServiceClass.getDeclaredMethod("undeployBundle", String.class);
        this.runDeploymentPreprocessor = reloadServiceClass.getDeclaredMethod("runDeploymentPreprocessor", new Class[0]);
        this.installWebResources = reloadServiceClass.getDeclaredMethod("installWebResources", File.class);
        this.flush = reloadServiceClass.getDeclaredMethod("flush", new Class[0]);
        this.reload = reloadServiceClass.getDeclaredMethod("reload", new Class[0]);
        this.flushSeam = reloadServiceClass.getDeclaredMethod("flushSeamComponents", new Class[0]);
        this.reloadSeam = reloadServiceClass.getDeclaredMethod("reloadSeamComponents", new Class[0]);
    }

    protected void hotDeployBundles(DevBundle[] bundles) throws Exception {
        this.flush();
        boolean hasSeam = false;
        for (DevBundle bundle : bundles) {
            if (bundle.devBundleType == DevBundleType.Bundle) {
                bundle.name = (String)this.deployBundle.invoke(this.reloadService, bundle.file());
                this.installWebResources.invoke(this.reloadService, bundle.file());
                continue;
            }
            if (!bundle.devBundleType.equals((Object)DevBundleType.Seam)) continue;
            hasSeam = true;
        }
        if (hasSeam) {
            this.reloadSeam.invoke(this.reloadService, new Object[0]);
        }
        this.reload();
    }

    protected void hotUndeployBundles(DevBundle[] bundles) throws Exception {
        boolean hasSeam = false;
        for (DevBundle bundle : bundles) {
            if (bundle.devBundleType.equals((Object)DevBundleType.Bundle) && bundle.name != null) {
                this.undeployBundle.invoke(this.reloadService, bundle.name);
                continue;
            }
            if (!bundle.devBundleType.equals((Object)DevBundleType.Seam)) continue;
            hasSeam = true;
        }
        if (hasSeam) {
            this.flushSeam.invoke(this.reloadService, new Object[0]);
        }
    }

    protected void flush() throws Exception {
        this.flush.invoke(this.reloadService, new Object[0]);
    }

    protected void reload() throws Exception {
        this.reload.invoke(this.reloadService, new Object[0]);
    }

    protected void reloadSeam() throws Exception {
        this.reloadSeam.invoke(this.reloadService, new Object[0]);
    }

    protected void runDeploymentPreprocessor() throws Exception {
        this.runDeploymentPreprocessor.invoke(this.reloadService, new Object[0]);
    }
}

