/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.runtime.NXRuntime;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.api.login.LoginService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Framework {
    private static RuntimeService runtime;

    private Framework() {
    }

    public static void initialize(RuntimeService runtimeService) throws Exception {
        if (runtime != null) {
            throw new Exception("Nuxeo Framework was already initialized");
        }
        runtime = runtimeService;
        NXRuntime.setRuntime(runtime);
        runtime.start();
    }

    public static void shutdown() throws Exception {
        if (runtime != null) {
            runtime.stop();
            NXRuntime.setRuntime(null);
            runtime = null;
        }
    }

    public static RuntimeService getRuntime() {
        return runtime;
    }

    public static <T> T getService(Class<T> serviceClass) throws Exception {
        return ServiceManager.getInstance().getService(serviceClass);
    }

    public static <T> T getService(Class<T> serviceClass, String name) throws Exception {
        return ServiceManager.getInstance().getService(serviceClass, name);
    }

    public static <T> T getLocalService(Class<T> serviceClass) {
        ServiceProvider provider = DefaultServiceProvider.getProvider();
        if (provider != null) {
            return provider.getService(serviceClass);
        }
        return runtime.getService(serviceClass);
    }

    public static Object lookup(String key) {
        return null;
    }

    public static LoginContext login() throws LoginException {
        if (null == runtime) {
            throw new IllegalStateException("runtime not initialized");
        }
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login();
        }
        return null;
    }

    public static LoginContext loginAs(String username) throws LoginException {
        if (null == runtime) {
            throw new IllegalStateException("runtime not initialized");
        }
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.loginAs(username);
        }
        return null;
    }

    public static LoginContext login(String username, Object password) throws LoginException {
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login(username, password);
        }
        return null;
    }

    public static LoginContext login(CallbackHandler cbHandler) throws LoginException {
        LoginService loginService = runtime.getService(LoginService.class);
        if (loginService != null) {
            return loginService.login(cbHandler);
        }
        return null;
    }

    public static String getProperty(String key) {
        return Framework.getProperty(key, null);
    }

    public static String getProperty(String key, String defValue) {
        return runtime.getProperty(key, defValue);
    }

    public static Properties getProperties() {
        return runtime.getProperties();
    }

    public static String expandVars(String expression) {
        int p = expression.indexOf("${");
        if (p == -1) {
            return expression;
        }
        char[] buf = expression.toCharArray();
        StringBuilder result = new StringBuilder(buf.length);
        if (p > 0) {
            result.append(expression.substring(0, p));
        }
        StringBuilder varBuf = new StringBuilder();
        boolean dollar = false;
        boolean var = false;
        block5: for (int i = p; i < buf.length; ++i) {
            char c = buf[i];
            switch (c) {
                case '$': {
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (!dollar) continue block5;
                    dollar = false;
                    var = true;
                    continue block5;
                }
                case '}': {
                    if (!var) continue block5;
                    var = false;
                    String varName = varBuf.toString();
                    varBuf.setLength(0);
                    String varValue = Framework.getProperty(varName);
                    if (varValue != null) {
                        result.append(varValue);
                        continue block5;
                    }
                    result.append("${").append(varName).append('}');
                    continue block5;
                }
                default: {
                    if (var) {
                        varBuf.append(c);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static void main(String[] args) {
    }
}

