/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.naming.InvalidNameException;
import javax.naming.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiName
implements Name {
    private static final long serialVersionUID = -4112999828077524879L;
    public static final char SEP = '/';
    protected static final String[] NO_SEGMENTS = new String[0];
    protected String[] segments;
    protected int hashCode;

    public JndiName() {
    }

    public JndiName(String ... segments) {
        this.segments = segments;
    }

    public JndiName(String path) {
        this.init(path);
    }

    protected void init(String path) {
        int size;
        ArrayList<String> segments = new ArrayList<String>();
        int slash = 0;
        int off = 0;
        int cnt = 0;
        int len = path.length();
        if (len == 0) {
            this.segments = NO_SEGMENTS;
            return;
        }
        if (len == 1) {
            char c = path.charAt(0);
            if (c == '/') {
                this.segments = NO_SEGMENTS;
                return;
            }
            if (c == '.') {
                this.segments = NO_SEGMENTS;
                return;
            }
            this.segments = new String[]{path};
            return;
        }
        char[] chars = path.toCharArray();
        block4: for (int i = 0; i < len; ++i) {
            char c = chars[i];
            switch (c) {
                case '/': {
                    if (slash == 0) {
                        if (cnt > 0) {
                            segments.add(new String(chars, off, cnt));
                            cnt = 0;
                        }
                        off = i;
                    } else {
                        ++off;
                    }
                    ++slash;
                    continue block4;
                }
                case '.': {
                    if (slash > 0 || i == 0) {
                        if (i < chars.length - 2) {
                            char c1 = chars[i + 1];
                            char c2 = chars[i + 2];
                            if (c1 == '.' && c2 == '/') {
                                if (segments.isEmpty()) {
                                    segments.add("..");
                                } else {
                                    segments.remove(segments.size() - 1);
                                }
                                i += 2;
                                slash = 1;
                                continue block4;
                            }
                            if (c1 == '/') {
                                ++i;
                                slash = 1;
                                continue block4;
                            }
                        } else if (i < chars.length - 1 && chars[i + 1] == '/') {
                            slash = 0;
                            continue block4;
                        }
                        slash = 0;
                    }
                }
                default: {
                    if (slash > 0) {
                        slash = 0;
                        off = i;
                    }
                    ++cnt;
                }
            }
        }
        if (cnt > 0) {
            segments.add(new String(chars, off, cnt));
        }
        this.segments = (size = segments.size()) == 0 ? NO_SEGMENTS : segments.toArray(new String[segments.size()]);
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        if (posn < 0 && posn > this.segments.length) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        String[] tmp = new String[this.segments.length + 1];
        if (posn == 0) {
            System.arraycopy(this.segments, 0, tmp, 1, this.segments.length);
            tmp[0] = comp;
        } else if (posn == this.segments.length) {
            System.arraycopy(this.segments, 0, tmp, 0, this.segments.length);
            tmp[this.segments.length] = comp;
        } else {
            System.arraycopy(this.segments, 0, tmp, 0, posn);
            tmp[posn] = comp;
            System.arraycopy(this.segments, posn, tmp, posn + 1, this.segments.length - posn);
        }
        this.segments = tmp;
        this.hashCode = 0;
        return this;
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        String[] tmp = new String[this.segments.length + 1];
        System.arraycopy(this.segments, 0, tmp, 0, this.segments.length);
        tmp[this.segments.length] = comp;
        this.segments = tmp;
        this.hashCode = 0;
        return this;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        int n = suffix.size();
        if (n > 0) {
            int len = this.segments.length;
            String[] tmp = new String[len + n];
            System.arraycopy(this.segments, 0, tmp, 0, len);
            this.segments = tmp;
            for (int i = 0; i < n; ++i) {
                this.segments[len + i] = suffix.get(i);
            }
        }
        this.hashCode = 0;
        return this;
    }

    @Override
    public Name addAll(int posn, Name name) throws InvalidNameException {
        if (posn < 0 && posn > this.segments.length) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        int size = name.size();
        if (size == 0) {
            return this;
        }
        String[] tmp = new String[this.segments.length + size];
        if (posn == 0) {
            for (int i = 0; i < size; ++i) {
                tmp[i] = name.get(i);
            }
            System.arraycopy(this.segments, 0, tmp, size, this.segments.length);
        } else if (posn == this.segments.length) {
            System.arraycopy(this.segments, 0, tmp, 0, this.segments.length);
            for (int i = 0; i < size; ++i) {
                tmp[i] = name.get(i);
            }
        } else {
            System.arraycopy(this.segments, 0, tmp, 0, posn);
            for (int i = 0; i < size; ++i) {
                tmp[i] = name.get(i);
            }
            System.arraycopy(this.segments, posn, tmp, posn + size, this.segments.length);
        }
        this.segments = tmp;
        this.hashCode = 0;
        return this;
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        if (posn < 0 || posn >= this.segments.length) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        String comp = this.segments[posn];
        String[] tmp = new String[this.segments.length - 1];
        if (posn == 0) {
            System.arraycopy(this.segments, 1, tmp, 0, tmp.length);
        } else if (posn == this.segments.length - 1) {
            System.arraycopy(this.segments, 0, tmp, 0, tmp.length);
        } else {
            System.arraycopy(this.segments, 0, tmp, 0, posn);
            System.arraycopy(this.segments, posn + 1, tmp, posn, this.segments.length - posn - 1);
        }
        this.segments = tmp;
        this.hashCode = 0;
        return comp;
    }

    @Override
    public boolean endsWith(Name n) {
        int size = n.size();
        if (size > this.segments.length) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        int s = this.segments.length - size;
        int i = this.segments.length - 1;
        int k = size - 1;
        while (i >= s) {
            if (!this.segments[i].equals(n.get(k))) {
                return false;
            }
            --i;
            --k;
        }
        return true;
    }

    @Override
    public boolean startsWith(Name n) {
        int size = n.size();
        if (size > this.segments.length) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            if (this.segments[i].equals(n.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String get(int posn) {
        return this.segments[posn];
    }

    @Override
    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    @Override
    public int size() {
        return this.segments.length;
    }

    @Override
    public Name getPrefix(int posn) {
        if (posn < 0 || posn > this.segments.length) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        String[] tmp = new String[posn];
        if (posn > 0) {
            System.arraycopy(this.segments, 0, tmp, 0, tmp.length);
        }
        return new JndiName(tmp);
    }

    @Override
    public Name getSuffix(int posn) {
        if (posn < 0 || posn > this.segments.length) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        String[] tmp = new String[this.segments.length - posn];
        if (posn < this.segments.length) {
            System.arraycopy(this.segments, posn, tmp, 0, tmp.length);
        }
        return new JndiName(tmp);
    }

    @Override
    public Enumeration<String> getAll() {
        return Collections.enumeration(Arrays.asList(this.segments));
    }

    @Override
    public Object clone() {
        return new JndiName(this.segments);
    }

    @Override
    public int compareTo(Object obj) {
        Name name = (Name)obj;
        int size = name.size();
        int r = this.segments.length - size;
        if (r != 0) {
            return r;
        }
        for (int i = 0; i < size; ++i) {
            r = this.segments[i].compareTo(name.get(i));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public String toString() {
        if (this.segments.length == 0) {
            return "";
        }
        if (this.segments.length == 1) {
            return this.segments[0];
        }
        StringBuilder buf = new StringBuilder(this.segments.length * 16);
        buf.append(this.segments[0]);
        for (int i = 1; i < this.segments.length; ++i) {
            buf.append("/").append(this.segments[i]);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        Name n;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Name && this.segments.length == (n = (Name)obj).size()) {
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.segments[i].equals(n.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    protected int computeHashCode() {
        int hash = 17;
        int segmentCount = this.segments.length;
        for (int i = 0; i < segmentCount; ++i) {
            hash = hash * 37 + this.segments[i].hashCode();
        }
        return hash;
    }
}

