/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.binding.JndiName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindings
implements BundleListener {
    public static final Log log = LogFactory.getLog(ServiceBindings.class);
    protected BundleContext bundleContext;
    protected InitialContext jndiContext;

    public ServiceBindings(BundleContext ctx) throws NamingException {
        this(ctx, new InitialContext());
    }

    public ServiceBindings(BundleContext bundleContext, InitialContext jndContext) {
        this.bundleContext = bundleContext;
        this.bundleContext.addBundleListener((BundleListener)this);
        this.jndiContext = jndContext;
    }

    public void createAlias(String fromName, String aliasName) throws NamingException {
        ServiceBindings.createAlias(this.jndiContext, fromName, aliasName);
    }

    public void removeAlias(String aliasName) throws NamingException {
        ServiceBindings.removeAlias(this.jndiContext, aliasName);
    }

    public void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        try {
            switch (event.getType()) {
                case 2: {
                    Properties properties = this.loadBindings(event.getBundle());
                    if (properties == null) break;
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String itf = entry.getKey().toString();
                        String impl = entry.getValue().toString();
                        this.createAlias(this.getLocalName(impl), this.createLocalJndiName(itf));
                        this.createAlias(this.getRemoteName(impl), this.createRemoteJndiName(itf));
                    }
                    break;
                }
                case 4: {
                    Properties properties = this.loadBindings(event.getBundle());
                    if (properties == null) break;
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String itf = entry.getKey().toString();
                        this.removeAlias(this.createLocalJndiName(itf));
                        this.removeAlias(this.createRemoteJndiName(itf));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process bundle: " + event.getBundle().getSymbolicName()), (Throwable)e);
        }
    }

    protected String createLocalJndiName(String serviceInterface) {
        return "nxservice/" + serviceInterface + "/local";
    }

    protected String createRemoteJndiName(String serviceInterface) {
        return "nxservice/" + serviceInterface + "/remote";
    }

    public Name getLocalServiceName(Class<?> itf) {
        return new JndiName("nxservice", itf.getName(), "local");
    }

    public Name getRemoteServiceName(Class<?> itf) {
        return new JndiName("nxservice", itf.getName(), "remote");
    }

    public Name getLocalServiceName(String name) {
        return new JndiName("nxservice", name, "local");
    }

    public Name getRemoteServiceName(String name) {
        return new JndiName("nxservice", name, "remote");
    }

    protected String getRemoteName(String beanClass) {
        String name = null;
        int p = beanClass.lastIndexOf(46);
        name = p > -1 ? beanClass.substring(p + 1) : beanClass;
        return "nuxeo/" + name + "/remote";
    }

    protected String getLocalName(String beanClass) {
        String name = null;
        int p = beanClass.lastIndexOf(46);
        name = p > -1 ? beanClass.substring(p + 1) : beanClass;
        return "nuxeo/" + name + "/local";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadBindings(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("OSGI-INF/service.bindings");
        if (url != null) {
            InputStream in = url.openStream();
            try {
                Properties properties = new Properties();
                properties.load(in);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    public static void createAlias(InitialContext ctx, String existingName, String aliasName) throws NamingException {
        LinkRef link = new LinkRef(existingName);
        Context aliasCtx = ctx;
        Name name = ctx.getNameParser("").parse(aliasName);
        int len = name.size() - 1;
        String atom = name.get(len);
        for (int i = 0; i < len; ++i) {
            String comp = name.get(i);
            try {
                aliasCtx = (Context)aliasCtx.lookup(comp);
                continue;
            }
            catch (NameNotFoundException e) {
                aliasCtx = aliasCtx.createSubcontext(comp);
            }
        }
        aliasCtx.rebind(atom, (Object)link);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created JNDI link [" + aliasName + "] pointing to [" + existingName + "]"));
        }
    }

    public static void removeAlias(InitialContext context, String aliasName) throws NamingException {
        context.unbind(aliasName);
    }
}

