/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.deploy.Contribution;
import org.nuxeo.runtime.deploy.ContributionManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class ManagedComponent
extends DefaultComponent {
    protected static Log log = LogFactory.getLog(ManagedComponent.class);
    protected Map<String, ContributionManager> contributionManagers;

    public void activate(ComponentContext context) throws Exception {
        this.contributionManagers = new HashMap<String, ContributionManager>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.contributionManagers = null;
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            if (contrib instanceof Contribution) {
                Contribution c = (Contribution)contrib;
                c.setExtension(extension);
                ContributionManager mgr = this.contributionManagers.get(c.getExtensionPoint());
                if (mgr != null) {
                    mgr.registerContribution(c);
                    continue;
                }
                log.warn((Object)("Unable to register contribution: " + c.getContributionId() + " for extension point " + c.getExtensionPoint() + ". No manager registered."));
                continue;
            }
            this.registerContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs = extension.getContributions();
        if (contribs == null) {
            return;
        }
        for (Object contrib : contribs) {
            if (contrib instanceof Contribution) {
                Contribution c = (Contribution)contrib;
                c.setExtension(extension);
                ContributionManager mgr = this.contributionManagers.get(c.getExtensionPoint());
                if (mgr != null) {
                    this.unregisterContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
                    mgr.unregisterContribution(c);
                    continue;
                }
                log.warn((Object)("Unable to unregister contribution: " + c.getContributionId() + " for extension point " + c.getExtensionPoint() + ". No manager registered."));
                continue;
            }
            this.unregisterContribution(contrib, extension.getExtensionPoint(), extension.getComponent());
        }
    }

    public void registerContributionManager(String extensionPoint, ContributionManager mgr) {
        this.contributionManagers.put(extensionPoint, mgr);
    }
}

