/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OSGiRuntimeService
extends AbstractRuntimeService
implements FrameworkListener {
    public static final String PROP_HOME_DIR = "org.nuxeo.runtime.home";
    public static final String PROP_INSTALL_DIR = "INSTALL_DIR";
    public static final String PROP_CONFIG_DIR = "CONFIG_DIR";
    public static final String PROP_HOST_ADAPTER = "HOST_ADAPTER";
    public static final String PROP_NUXEO_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String NAME = "OSGi NXRuntime";
    public static final Version VERSION = Version.parseString("1.4.0");
    private static final Log log = LogFactory.getLog(OSGiRuntimeService.class);
    private final BundleContext bundleContext;
    private final Map<String, RuntimeContext> contexts;

    public OSGiRuntimeService(BundleContext context) {
        super(new OSGiRuntimeContext(context.getBundle()));
        String homeDir;
        this.bundleContext = context;
        this.contexts = new ConcurrentHashMap<String, RuntimeContext>();
        String bindAddress = context.getProperty(PROP_NUXEO_BIND_ADDRESS);
        if (bindAddress != null) {
            this.properties.put(PROP_NUXEO_BIND_ADDRESS, bindAddress);
        }
        this.workingDir = (homeDir = this.getProperty(PROP_HOME_DIR)) != null ? new File(homeDir) : this.bundleContext.getDataFile("/");
        this.workingDir.mkdirs();
    }

    public String getName() {
        return NAME;
    }

    public Version getVersion() {
        return VERSION;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public synchronized RuntimeContext createContext(Bundle bundle) throws Exception {
        RuntimeContext ctx = this.contexts.get(bundle);
        if (ctx == null) {
            ctx = new OSGiRuntimeContext(bundle);
            this.contexts.put(bundle.getSymbolicName(), ctx);
            this.loadComponents(bundle, ctx);
        }
        return ctx;
    }

    public synchronized void destroyContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.remove(bundle);
        if (ctx != null) {
            ctx.destroy();
        }
    }

    public synchronized RuntimeContext getContext(Bundle bundle) {
        return this.contexts.get(bundle);
    }

    protected void doStart() throws Exception {
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
        this.loadConfig();
        this.loadComponents(this.bundleContext.getBundle(), this.context);
    }

    protected void doStop() throws Exception {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        super.doStop();
        this.context.destroy();
    }

    protected void loadComponents(Bundle bundle, RuntimeContext ctx) throws Exception {
        String list = OSGiRuntimeService.getComponentsList(bundle);
        if (list == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, ", \t\n\r\f");
        while (tok.hasMoreTokens()) {
            String desc = tok.nextToken();
            URL url = bundle.getEntry(desc);
            if (url != null) {
                try {
                    ctx.deploy(url);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error deploying resource: " + url));
                    throw e;
                }
            }
            String message = "Unknown component '" + desc + "' referenced by bundle '" + bundle.getSymbolicName() + "'";
            log.error((Object)(message + ". Check the MANIFEST.MF"));
            this.warnings.add(message);
        }
    }

    public static String getComponentsList(Bundle bundle) {
        return (String)bundle.getHeaders().get("Nuxeo-Component");
    }

    protected void loadConfig() throws Exception {
        File dir;
        String configDir = Framework.getProperty("org.nuxeo.config.dir");
        if (configDir != null) {
            dir = new File(configDir);
            System.out.println(dir.getAbsolutePath());
            if (dir.isDirectory()) {
                for (String name : dir.list()) {
                    File file;
                    if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml")) {
                        file = new File(dir, name);
                        this.context.deploy(file.toURL());
                        continue;
                    }
                    if (!name.endsWith(".config") && !name.endsWith(".ini") && !name.endsWith(".properties")) continue;
                    file = new File(dir, name);
                    this.loadProperties(file);
                }
                return;
            }
        }
        if ((configDir = this.bundleContext.getProperty(PROP_CONFIG_DIR)) == null) {
            return;
        }
        if (configDir.contains(":/")) {
            URL url = new URL(configDir);
            this.loadProperties(url);
            return;
        }
        dir = new File(configDir);
        if (dir.isDirectory()) {
            for (String name : dir.list()) {
                if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml") || !name.endsWith(".config") && !name.endsWith(".ini") && !name.endsWith(".properties")) continue;
                File file = new File(dir, name);
                this.loadProperties(file);
            }
        } else {
            File file = new File(configDir);
            this.loadProperties(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadProperties(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            this.loadProperties(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            this.properties.put(prop.getKey().toString(), prop.getValue().toString());
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.printStatusMessage();
        }
    }

    private void printStatusMessage() {
        String hr = "===========================================================";
        StringBuilder msg = new StringBuilder("Nuxeo EP Started\n");
        msg.append(hr).append("\n= Nuxeo EP Started\n");
        if (!this.warnings.isEmpty()) {
            msg.append(hr).append("\n= Component Loading Errors:\n");
            for (String warning : this.warnings) {
                msg.append("  * ").append(warning).append('\n');
            }
        }
        Map<ComponentName, Set<ComponentName>> pending = this.manager.getPendingRegistrations();
        msg.append(hr).append("\n= Component Loading Status: Pending: ").append(pending.size()).append(" / Total: ").append(this.manager.getRegistrations().size()).append('\n');
        for (Map.Entry<ComponentName, Set<ComponentName>> e : pending.entrySet()) {
            msg.append("  * ").append(e.getKey()).append(" requires ").append(e.getValue()).append('\n');
        }
        msg.append(hr);
        if (this.warnings.isEmpty() && pending.isEmpty()) {
            log.info((Object)msg);
        } else {
            log.error((Object)msg);
        }
    }

    public Bundle findHostBundle(Bundle bundle) {
        String hostId = (String)bundle.getHeaders().get("Fragment-Host");
        if (hostId != null) {
            RuntimeContext ctx;
            int p = hostId.indexOf(59);
            if (p > -1) {
                hostId = hostId.substring(0, p);
            }
            if ((ctx = this.contexts.get(hostId)) != null) {
                return ctx.getBundle();
            }
        }
        return null;
    }

    public File getBundleFile(Bundle bundle) {
        File file = null;
        String location = bundle.getLocation();
        String vendor = Framework.getProperty("org.osgi.framework.vendor");
        if ("Eclipse".equals(vendor)) {
            if (location.endsWith("/")) {
                location = location.substring(0, location.length() - 1);
            }
            if (location.startsWith("update@")) {
                location = location.substring("update@".length());
            } else if (location.startsWith("initial@reference:file:")) {
                location = location.substring("initial@reference:file:".length());
            }
            file = new File(location);
        } else if (location.startsWith("file:")) {
            try {
                file = new File(new URI(location));
            }
            catch (Exception e) {
                return null;
            }
        }
        return file != null && file.exists() ? file : null;
    }
}

