/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.remoting.InvokerLocator;

public class LocatorHelper {
    private static final String ANY = "0.0.0.0";
    private static final String SERVER_BIND_ADDRESS = "jboss.bind.address";
    public static final int DEFAULT_PORT = 62474;

    public static final InvokerLocator getLocator(String protocol, String host, int port, String path, Map parameters) {
        if (protocol == null) {
            protocol = "socket";
        }
        if (port <= 0) {
            port = 62474;
        }
        if (parameters == null) {
            parameters = new HashMap<String, String>();
            parameters.put("datatype", "nuxeo");
        } else if (!"nuxeo".equals(parameters.get("datatype"))) {
            parameters.put("datatype", "nuxeo");
        }
        return new InvokerLocator(protocol, host, port, path, parameters);
    }

    public static final InvokerLocator getLocator(String protocol, String host, int port) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("datatype", "nuxeo");
        return new InvokerLocator(protocol, host, port, "/", parameters);
    }

    public static final InvokerLocator getLocator(String host, int port) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("datatype", "nuxeo");
        return new InvokerLocator("socket", host, port, "/", parameters);
    }

    public static final InvokerLocator getLocator(String host) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("datatype", "nuxeo");
        return new InvokerLocator("socket", host, 62474, "/", parameters);
    }

    public static InvokerLocator parse(String uri) throws MalformedURLException {
        String protocol = null;
        String host = null;
        String path = null;
        int port = 0;
        HashMap<String, String> parameters = null;
        int i = uri.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException("Invalid url " + uri);
        }
        String tmp = uri.substring(i + 3);
        protocol = uri.substring(0, i);
        i = tmp.indexOf("/");
        int p = tmp.lastIndexOf(":");
        if (p != -1) {
            host = LocatorHelper.resolveHost(tmp.substring(0, p).trim());
            port = i > -1 ? Integer.parseInt(tmp.substring(p + 1, i)) : Integer.parseInt(tmp.substring(p + 1));
        } else {
            host = i > -1 ? LocatorHelper.resolveHost(tmp.substring(0, i).trim()) : LocatorHelper.resolveHost(tmp.substring(0).trim());
            port = -1;
        }
        p = tmp.indexOf("?");
        if (p != -1) {
            path = tmp.substring(i + 1, p);
            String args = tmp.substring(p + 1);
            StringTokenizer tok = new StringTokenizer(args, "&");
            parameters = new HashMap();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int eq = token.indexOf("=");
                String name = eq > -1 ? token.substring(0, eq) : token;
                String value = eq > -1 ? token.substring(eq + 1) : "";
                parameters.put(name, value);
            }
        } else {
            p = tmp.indexOf("/");
            path = p != -1 ? tmp.substring(p + 1) : "";
        }
        if (parameters == null) {
            parameters = new HashMap<String, String>();
            parameters.put("datatype", "nuxeo");
        } else if (!"nuxeo".equals(parameters.get("datatype"))) {
            parameters.put("datatype", "nuxeo");
        }
        return new InvokerLocator(protocol, host, port, path, parameters);
    }

    public static final String resolveHost(String host) {
        if (host.indexOf(ANY) != -1) {
            host = System.getProperty(SERVER_BIND_ADDRESS, ANY).equals(ANY) ? LocatorHelper.fixRemoteAddress(host) : host.replaceAll("0\\.0\\.0\\.0", System.getProperty(SERVER_BIND_ADDRESS));
        }
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception ex) {
            return host;
        }
    }

    public static String fixRemoteAddress(String address) {
        block5: {
            try {
                if (address != null && !ANY.equals(address)) break block5;
                boolean byHost = true;
                String bindByHost = System.getProperty("remoting.bind_by_host", "True");
                try {
                    byHost = Boolean.getBoolean(bindByHost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (byHost) {
                    return InetAddress.getLocalHost().getHostName();
                }
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return address;
    }
}

