/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.remoting.RemoteContext;
import org.nuxeo.runtime.remoting.ServerDescriptor;

public class RemoteComponent {
    private final Set<Extension> extensions;
    private final ServerDescriptor sd;
    private final ComponentName name;
    private RemoteContext context;

    public RemoteComponent(ServerDescriptor sd, ComponentName name) {
        this.sd = sd;
        this.name = name;
        this.extensions = new HashSet<Extension>();
    }

    public RemoteContext getContext() throws Exception {
        if (this.context == null) {
            this.context = new RemoteContext(this.sd, this.name, null);
        }
        return this.context;
    }

    public ComponentName getName() {
        return this.name;
    }

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }

    public Extension[] getExtensions() {
        return this.extensions.toArray(new Extension[this.extensions.size()]);
    }
}

