/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting.transporter;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.detection.Detector;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.transport.Connector;
import org.nuxeo.runtime.remoting.transporter.TransporterHandler;

public class TransporterServer {
    private Connector connector = new Connector();
    private static MBeanServer server = null;
    private static Detector detector = null;

    public TransporterServer(InvokerLocator locator, Object target, String subsystem) throws Exception {
        this.connector.setInvokerLocator(locator.getLocatorURI());
        this.connector.create();
        TransporterHandler handler = new TransporterHandler(target);
        this.connector.addInvocationHandler(subsystem, (ServerInvocationHandler)handler);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void addHandler(Object target, String proxyclassname) throws Exception {
        if (this.connector == null) {
            throw new Exception("Can not add handler to transporter server as has not be initialized yet.");
        }
        this.connector.addInvocationHandler(proxyclassname, (ServerInvocationHandler)new TransporterHandler(target));
    }

    public String getLocatorURI() {
        try {
            return this.connector.getInvokerLocator();
        }
        catch (Exception e) {
            throw new Error("Failed to get locator URI", e);
        }
    }

    public void start() throws Exception {
        this.connector.start();
    }

    public void stop() {
        this.connector.stop();
    }

    private static void setupDetector() throws Exception {
        server = MBeanServerFactory.createMBeanServer();
        detector = new MulticastDetector();
        server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
        detector.start();
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem, boolean isClustered) throws Exception {
        if (isClustered && detector == null) {
            TransporterServer.setupDetector();
        }
        TransporterServer server = new TransporterServer(locator, target, subsystem);
        server.start();
        return server;
    }

    public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem, boolean isClustered) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, isClustered);
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target, String subsystem) throws Exception {
        return TransporterServer.createTransporterServer(locator, target, subsystem, false);
    }

    public static TransporterServer createTransporterServer(String locatorURI, Object target, String subsystem) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locatorURI), target, subsystem, false);
    }

    public static TransporterServer createTransporterServer(InvokerLocator locator, Object target) throws Exception {
        return TransporterServer.createTransporterServer(locator, target, target.getClass().getName());
    }

    public static TransporterServer createTransporterServer(String locatorURI, Object target) throws Exception {
        return TransporterServer.createTransporterServer(new InvokerLocator(locatorURI), target);
    }
}

