/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.runtime.binding.AbstractServiceProvider;
import org.nuxeo.runtime.binding.Binding;
import org.nuxeo.runtime.binding.StaticBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleServiceProvider
extends AbstractServiceProvider {
    protected Map<String, Entry> registry;

    public SimpleServiceProvider() {
        this(new HashMap<String, Entry>());
    }

    public SimpleServiceProvider(Map<String, Entry> registry) {
        this.registry = registry;
    }

    public void registerService(Class<?> itf, Object serviceInstance) {
        Entry entry = new Entry();
        entry.obj = serviceInstance;
        entry.itf = itf;
        this.registry.put(itf.getName(), entry);
    }

    public void unregisterService(Class<?> itf) {
        Entry entry = this.registry.remove(itf);
        if (entry == null || entry.bindingKey != null) {
            // empty if block
        }
    }

    public Map<String, Entry> getRegistry() {
        return this.registry;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getService(Class<?> serviceClass, String bindingKey) {
        String name = serviceClass.getName();
        Entry obj = this.registry.get(name);
        if (obj != null && this.manager != null) {
            if (obj instanceof Binding) {
                this.manager.registerBinding(bindingKey, (Binding)((Object)obj));
            } else {
                this.manager.registerBinding(bindingKey, new StaticBinding(bindingKey, obj));
            }
            return obj;
        }
        return null;
    }

    public class Entry {
        public Object obj;
        public Class<?> itf;
        public String bindingKey;
    }
}

