/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.models.InfoPool;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.views.TemplateView;
import org.nuxeo.theme.views.ViewType;

public class HTMLView
extends TemplateView {
    private static final Log log = LogFactory.getLog(HTMLView.class);
    private static final Pattern firstTagPattern = Pattern.compile("<([a-zA-Z0-9:]*)[^>]*>", 32);
    private static final String[] ALLOWED_TAGS = new String[]{"html", "body", "table", "tr", "td", "div"};

    public String render(RenderingInfo info) {
        ViewType viewType = this.getViewType();
        String template = viewType.getTemplate();
        String result = this.getTemplateContent(template);
        Matcher matcher = firstTagPattern.matcher(result);
        if (matcher.find()) {
            String tag = matcher.group(1).toLowerCase();
            boolean found = false;
            for (String allowedTag : ALLOWED_TAGS) {
                if (!tag.equals(allowedTag)) continue;
                found = true;
            }
            if (!found) {
                log.warn((Object)String.format("First HTML tag of view template: %s (<%s>) not one of <html>, <body>, <div>, <table>, <tr>, <td>", template, tag));
            }
        } else {
            log.warn((Object)("First HTML tag of view template: " + template + " not found"));
        }
        String infoId = InfoPool.computeInfoId((RenderingInfo)info);
        result = result.replaceAll("nxthemesInfo.", String.format("nxthemesInfo.map.%s.", infoId));
        result = result.replace("[nxthemes markup]", info.getMarkup());
        return result;
    }
}

