/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.servlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.html.JSUtils;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

public final class Resources
extends HttpServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Resources.class);
    private static final Pattern pathPattern = Pattern.compile("/([^/]+)");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ApplicationType application;
        String[] resourceNames;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return;
        }
        Matcher m = pathPattern.matcher(pathInfo);
        if (!m.matches()) {
            log.error((Object)String.format("Invalid resource path: %s", pathInfo));
            return;
        }
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ThemeManager themeManager = Manager.getThemeManager();
        String contentType = null;
        for (String resourceName : resourceNames = m.group(1).split(",")) {
            String previousContentType = contentType;
            if (resourceName.endsWith(".js")) {
                contentType = "text/javascript";
            } else if (resourceName.endsWith(".css")) {
                contentType = "text/css";
            } else if (resourceName.endsWith(".json")) {
                contentType = "text/json";
            }
            if (contentType == null) {
                log.error((Object)("Resource names must end with .js, .css or .json: " + pathInfo));
                return;
            }
            if (previousContentType == null || contentType.equals(previousContentType)) continue;
            log.error((Object)("Combined resources must be of the same type: " + pathInfo));
            return;
        }
        response.addHeader("content-type", contentType);
        String applicationPath = request.getParameter("path");
        if (applicationPath != null && (application = (ApplicationType)Manager.getTypeRegistry().lookup(TypeFamily.APPLICATION, applicationPath)) != null) {
            Utils.setCacheHeaders(response, application.getResourceCaching());
        }
        StringBuilder text = new StringBuilder();
        String basePath = request.getParameter("basepath");
        for (String resourceName : resourceNames) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String source = themeManager.getResource(resourceName);
            if (source == null) {
                ResourceType resource = (ResourceType)typeRegistry.lookup(TypeFamily.RESOURCE, resourceName);
                if (resource == null) {
                    log.error((Object)String.format("Resource not registered %s.", resourceName));
                    continue;
                }
                Resources.writeResource(resource, out);
                source = ((Object)out).toString();
                if (resourceName.endsWith(".js") && resource.isShrinkable()) {
                    source = JSUtils.compressSource(source);
                } else if (resourceName.endsWith(".css")) {
                    source = source.replaceAll("\\$\\{basePath\\}", Matcher.quoteReplacement(basePath));
                }
                themeManager.setResource(resourceName, source);
            }
            text.append(source);
        }
        boolean supportsGzip = Utils.supportsGzip(request);
        Object os = response.getOutputStream();
        if (supportsGzip) {
            response.setHeader("Content-Encoding", "gzip");
            response.setHeader("Vary", "Accept-Encoding");
            os = new GZIPOutputStream((OutputStream)os);
        }
        try {
            os.write(text.toString().getBytes());
            os.close();
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause != null && "Broken pipe".equals(cause.getMessage())) {
                log.debug((Object)("Swallowing: " + e));
            }
            throw e;
        }
        log.debug((Object)String.format("Served resource(s): %s %s", pathInfo, supportsGzip ? "with gzip compression" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResource(ResourceType resource, OutputStream out) {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource.getPath());
            if (in == null) {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream("nuxeo.war/" + resource.getPath());
            }
            if (in != null) {
                byte[] buffer = new byte[1024];
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    read = in.read(buffer);
                    out.flush();
                }
                out.close();
            } else {
                log.error((Object)String.format("Resource not found %s.", resource.getName()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

