/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.html.CssCompressor;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.properties.OrderedProperties;
import org.nuxeo.theme.resources.ImageInfo;
import org.nuxeo.theme.resources.ResourceBank;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.uids.Identifiable;

public final class CSSUtils {
    static final Log log = LogFactory.getLog(CSSUtils.class);
    private static final String EMPTY_CSS_SELECTOR = "EMPTY";
    private static final String CLASS_ATTR_PREFIX = "nxStyle";
    private static final String CSS_PROPERTIES_RESOURCE = "/nxthemes/html/styles/css.properties";
    private static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    private static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);
    private static final Pattern classAttrPattern = Pattern.compile(" class=\"(.*?)\"", 32);
    private static final Pattern emptyCssSelectorPattern = Pattern.compile("(.*?)\\{(.*?)\\}", 32);
    private static final Pattern hexColorPattern = Pattern.compile(".*?#(\\p{XDigit}{3,6}).*?", 32);
    private static final Pattern rgbColorPattern = Pattern.compile(".*?rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\).*?", 32);
    private static final Pattern urlPattern = Pattern.compile("^url\\s*\\([\\s,\",']*(.*?)[\\s,\",']*\\)$", 32);
    private static final Pattern partialUrlPattern = Pattern.compile("url\\s*\\([\\s,\",']*([^/].*?)[\\s,\",']*\\)", 32);
    private static final Pattern rgbDigitPattern = Pattern.compile("([0-9]{1,3},[0-9]{1,3},[0-9]{1,3})");
    private static final Properties cssProperties = new OrderedProperties();

    private CSSUtils() {
    }

    public static Properties getCssProperties() {
        return cssProperties;
    }

    public static String styleToCss(Style style, Collection<String> viewNames, boolean ignoreViewName, boolean ignoreClassName, boolean indent) {
        String themeName = null;
        if (style.isNamed()) {
            themeName = Manager.getThemeManager().getThemeNameOfNamedObject((Identifiable)style);
        } else {
            ThemeElement theme = ThemeManager.getThemeOfFormat((Format)style);
            if (theme != null) {
                themeName = theme.getName();
            }
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder pSb = new StringBuilder();
        for (String viewName : viewNames) {
            String className = CSSUtils.computeCssClassName(style);
            pSb.setLength(0);
            boolean addSpace = false;
            if (!ignoreClassName) {
                pSb.append('.').append(className);
                addSpace = true;
            }
            if (!ignoreViewName && !"*".equals(viewName)) {
                pSb.append(CSSUtils.toUpperCamelCase(viewName));
                addSpace = true;
            }
            for (String path : style.getPathsForView(viewName)) {
                Properties styleProperties = style.getPropertiesFor(viewName, path);
                String[] splitPaths = path.split(",");
                int len = splitPaths.length;
                for (int i = 0; i < len; ++i) {
                    sb.append((CharSequence)pSb);
                    if (addSpace && !"".equals(path)) {
                        sb.append(' ');
                    }
                    sb.append(splitPaths[i].trim());
                    if (i >= len - 1) continue;
                    sb.append(", ");
                }
                sb.append(" {");
                if (indent) {
                    sb.append('\n');
                }
                Enumeration<?> propertyNames = cssProperties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String value = styleProperties.getProperty(propertyName);
                    if (value == null) continue;
                    if (indent) {
                        sb.append("  ");
                    }
                    sb.append(propertyName);
                    sb.append(':');
                    if (indent) {
                        sb.append(' ');
                    }
                    sb.append(value).append(';');
                    if (!indent) continue;
                    sb.append('\n');
                }
                sb.append("}\n");
                if (!indent) continue;
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static String insertCssClass(String markup, String className) {
        Matcher firstMatcher = firstTagPattern.matcher(markup);
        Matcher othersMatcher = otherTagsPattern.matcher(markup);
        if (!firstMatcher.find() || !othersMatcher.find()) {
            return markup;
        }
        String inBrackets = firstMatcher.group(1);
        Matcher classAttrMatcher = classAttrPattern.matcher(inBrackets);
        StringBuilder classAttributes = new StringBuilder();
        if (classAttrMatcher.find()) {
            classAttributes.append(classAttrMatcher.group(1));
            if (!classAttributes.toString().endsWith(" ")) {
                classAttributes.append(' ');
            }
        }
        classAttributes.append(className);
        if (classAttributes.length() == 0) {
            return markup;
        }
        if ((inBrackets = inBrackets.replaceAll(classAttrPattern.toString(), "")).endsWith("/")) {
            return String.format("<%s class=\"%s\" />%s", inBrackets.replaceAll("/$", "").trim(), classAttributes.toString(), othersMatcher.group(1));
        }
        return String.format("<%s class=\"%s\">%s", inBrackets, classAttributes.toString(), othersMatcher.group(1));
    }

    public static String computeCssClassName(Style style) {
        String collectionName = style.getCollection();
        String prefix = CLASS_ATTR_PREFIX;
        if (collectionName != null) {
            prefix = CSSUtils.toCamelCase(collectionName);
        }
        return String.format("%s%s", prefix, style.getUid());
    }

    public static String replaceColor(String text, String before, String after) {
        String found;
        Matcher m = hexColorPattern.matcher(text);
        text = text.trim();
        while (m.find()) {
            found = "#" + CSSUtils.optimizeHexColor(m.group(1));
            if (!found.equals(before)) continue;
            text = text.replace(String.format("#%s", m.group(1)), after);
        }
        m = rgbColorPattern.matcher(text);
        while (m.find()) {
            found = "#" + CSSUtils.optimizeHexColor(CSSUtils.rgbToHex(m.group(1)));
            if (!found.equals(before)) continue;
            text = text.replace(String.format("rgb(%s)", m.group(1)), after);
        }
        return text;
    }

    public static String replaceImage(String text, String before, String after) {
        String found;
        Matcher m = urlPattern.matcher(text = text.trim());
        if (m.matches() && (found = String.format("url(%s)", m.group(1))).equals(before)) {
            text = text.replace(String.format("url(%s)", m.group(1)), after);
        }
        return text;
    }

    public static String optimizeHexColor(String value) {
        if ((value = value.toLowerCase()).length() != 6) {
            return value;
        }
        if (value.charAt(0) == value.charAt(1) && value.charAt(2) == value.charAt(3) && value.charAt(4) == value.charAt(5)) {
            return String.format("%s%s%s", Character.valueOf(value.charAt(0)), Character.valueOf(value.charAt(2)), Character.valueOf(value.charAt(4)));
        }
        return value;
    }

    public static String rgbToHex(String value) {
        value = value.replaceAll("\\s", "");
        Matcher m = rgbDigitPattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String[] rgb = m.group(1).split(",");
            StringBuffer hexcolor = new StringBuffer();
            for (String element : rgb) {
                int val = Integer.parseInt(element);
                if (val < 16) {
                    hexcolor.append("0");
                }
                hexcolor.append(Integer.toHexString(val));
            }
            m.appendReplacement(sb, hexcolor.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List<String> extractCssColors(String value) {
        ArrayList<String> colors = new ArrayList<String>();
        value = value.trim();
        Matcher m = hexColorPattern.matcher(value);
        while (m.find()) {
            colors.add("#" + CSSUtils.optimizeHexColor(m.group(1)));
        }
        m = rgbColorPattern.matcher(value);
        while (m.find()) {
            colors.add("#" + CSSUtils.optimizeHexColor(CSSUtils.rgbToHex(m.group(1))));
        }
        return colors;
    }

    public static List<String> extractCssImages(String value) {
        ArrayList<String> images = new ArrayList<String>();
        Matcher m = urlPattern.matcher(value = value.trim());
        if (m.matches()) {
            images.add(String.format("url(%s)", m.group(1)));
        }
        return images;
    }

    public static String toCamelCase(String value) {
        if (value == null || value.trim().equals("")) {
            return value;
        }
        String newValue = value.replaceAll("[^\\p{Alnum}]+", " ");
        StringBuilder sb = new StringBuilder();
        String[] parts = newValue.trim().split("\\s+");
        sb.append(parts[0].toLowerCase(Locale.ENGLISH));
        for (int i = 1; i < parts.length; ++i) {
            sb.append(parts[i].substring(0, 1).toUpperCase());
            sb.append(parts[i].substring(1).toLowerCase(Locale.ENGLISH));
        }
        return sb.toString();
    }

    public static String toUpperCamelCase(String value) {
        if ("".equals(value)) {
            return "";
        }
        String newValue = CSSUtils.toCamelCase(value);
        StringBuilder sb = new StringBuilder();
        sb.append(newValue.substring(0, 1).toUpperCase());
        sb.append(newValue.substring(1));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String compressSource(String source) throws ThemeException {
        String compressedSource = source;
        StringReader in = null;
        Writer out = null;
        int linebreakpos = -1;
        try {
            in = new StringReader(source);
            out = new StringWriter();
            CssCompressor compressor = new CssCompressor(in);
            compressor.compress(out, -1);
            compressedSource = out.toString();
        }
        catch (IOException e) {
            throw new ThemeException("Could not compress CSS", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    try {
                        out.close();
                        out = null;
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                        out = null;
                    }
                }
                catch (Throwable throwable) {
                    out = null;
                    throw throwable;
                }
            }
        }
        if (in == null) return compressedSource;
        try {
            try {
                ((Reader)in).close();
                in = null;
                return compressedSource;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                return compressedSource;
            }
        }
        finally {
            in = null;
        }
    }

    public static String expandPartialUrls(String text, String cssContextPath) {
        Matcher m = partialUrlPattern.matcher(text);
        if (!cssContextPath.endsWith("/")) {
            cssContextPath = cssContextPath + "/";
        }
        String replacement = String.format("url(%s$1)", Matcher.quoteReplacement(cssContextPath));
        return m.replaceAll(replacement);
    }

    public static String expandVariables(String text, String basePath, ThemeDescriptor themeDescriptor) {
        String themeName = themeDescriptor.getName();
        if (basePath != null) {
            text = text.replaceAll("\\$\\{basePath\\}", Matcher.quoteReplacement(basePath));
        }
        String contextPath = VirtualHostHelper.getContextPathProperty();
        text = PresetManager.resolvePresets((String)themeName, (String)text);
        String resourceBankName = themeDescriptor.getResourceBankName();
        if (resourceBankName != null) {
            try {
                ResourceBank resourceBank = ThemeManager.getResourceBank((String)resourceBankName);
                for (ImageInfo image : resourceBank.getImages()) {
                    String path = image.getPath();
                    text = text.replaceAll(Matcher.quoteReplacement(path), Matcher.quoteReplacement(String.format("%s/nxthemes-images/%s/%s", contextPath, resourceBankName, path.replace(" ", "%20"))));
                }
            }
            catch (ThemeException e) {
                log.warn((Object)("Could not get the list of bank images in: " + resourceBankName));
            }
        }
        return text;
    }

    static {
        Utils.loadProperties((Properties)cssProperties, (String)CSS_PROPERTIES_RESOURCE);
    }
}

