/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.component;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.faces.component.UIOutput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.jsf.URLUtils;

public class UIHead
extends UIOutput {
    private static final Log log = LogFactory.getLog(UIHead.class);

    public void encodeAll(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ExternalContext externalContext = context.getExternalContext();
        URL themeUrl = (URL)externalContext.getRequestMap().get("nxthemesThemeUrl");
        ThemeElement theme = Manager.getThemeManager().getThemeByUrl(themeUrl);
        Widget widget = (Widget)ElementFormatter.getFormatFor((Element)theme, (String)"widget");
        if (widget == null) {
            log.warn((Object)("Theme " + themeUrl + " has no widget format."));
        } else {
            Properties properties = widget.getProperties();
            String charset = properties.getProperty("charset", "utf-8");
            writer.write(String.format("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=%s\"/>", charset));
            String icon = properties.getProperty("icon", "/favicon.ico");
            writer.write(String.format("<link rel=\"icon\" href=\"%s\" type=\"image/x-icon\"/>", icon));
            writer.write(String.format("<link rel=\"shortcut icon\" href=\"%s\" type=\"image/x-icon\"/>", icon));
        }
        String contextPath = externalContext.getRequestContextPath();
        writer.write(String.format("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"/nuxeo/nxthemes-css/?path=%s\"/>", contextPath));
        ServletRequest request = (ServletRequest)externalContext.getRequest();
        String baseUrl = URLUtils.getBaseURL(request);
        if (baseUrl != null) {
            writer.write(String.format("<base href=\"%s\" />", baseUrl));
        }
    }
}

