/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets;

import com.sun.facelets.FaceletException;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.ResourceResolver;
import java.io.IOException;
import java.net.URL;
import org.nuxeo.theme.jsf.facelets.vendor.DefaultFacelet;
import org.nuxeo.theme.jsf.facelets.vendor.DefaultFaceletFactory;

public final class NXThemesFaceletFactory
extends DefaultFaceletFactory {
    public NXThemesFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public NXThemesFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        super(compiler, resolver, refreshPeriod);
    }

    protected boolean needsToBeRefreshed(DefaultFacelet facelet) {
        block8: {
            URL url = facelet.getSource();
            if (url.getProtocol().equals("nxtheme")) {
                try {
                    if (url.openConnection().getLastModified() > facelet.getCreateTime()) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception e) {
                    throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
                }
            }
            if (this.refreshPeriod != -1L) {
                long ttl = facelet.getCreateTime() + this.refreshPeriod;
                if (System.currentTimeMillis() > ttl) {
                    try {
                        long atl = url.openConnection().getLastModified();
                        return atl == 0L || atl > ttl;
                    }
                    catch (Exception e) {
                        throw new FaceletException("Error Checking Last Modified for " + facelet.getAlias(), (Throwable)e);
                    }
                }
            }
        }
        return false;
    }
}

