/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.negotiation;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public final class CookieManager {
    public static String getCookie(String name, ExternalContext context) {
        if (context == null) {
            return null;
        }
        Map cookies = context.getRequestCookieMap();
        Cookie cookie = (Cookie)cookies.get(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public static void setCookie(String name, String value, ExternalContext context) {
        if (context == null) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        String path = context.getRequestContextPath();
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        response.addCookie(cookie);
    }

    public static void expireCookie(String name, ExternalContext context) {
        if (context == null) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        String path = context.getRequestContextPath();
        Cookie cookie = new Cookie(name, "");
        cookie.setPath(path);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }
}

