/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.jsf.Utils;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.types.TypeFamily;

public abstract class UIBaseMVC
extends UIOutput {
    private static final Logger log = Logger.getLogger("nxthemes.jsf.component");
    private String resource;
    private String url;
    private Object binding;

    public abstract String getClassName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map attributes = this.getAttributes();
        this.resource = (String)attributes.get("resource");
        this.url = (String)attributes.get("url");
        this.binding = attributes.get("binding");
        writer.startElement("ins", (UIComponent)this);
        writer.writeAttribute("class", (Object)this.getClassName(), null);
        if (null != this.resource) {
            ResourceType resourceType = (ResourceType)Manager.getTypeRegistry().lookup(TypeFamily.RESOURCE, this.resource);
            if (resourceType == null) {
                log.warning("Could not find resource: " + this.resource);
            } else {
                InputStream inStream = null;
                try {
                    inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceType.getPath());
                    if (inStream != null) {
                        String inputLine;
                        BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
                        while ((inputLine = in.readLine()) != null) {
                            writer.write(inputLine);
                        }
                        in.close();
                    } else {
                        log.warning("Could not open resource file: " + resourceType.getPath());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (null != this.url) {
            writer.writeAttribute("cite", (Object)this.url, null);
        }
        if (null != this.binding) {
            String text = Utils.toJson(this.binding);
            writer.write(text);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ins");
    }

    public Object getBinding() {
        return this.binding;
    }

    public void setBinding(Object binding) {
        this.binding = binding;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

