/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.nuxeo.theme.jsf.Utils;
import org.nuxeo.theme.jsf.component.UITab;

public class UITabs
extends UIOutput {
    private String identifier;
    private String styleClass;
    private String controlledBy;

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map attributes = this.getAttributes();
        this.identifier = (String)attributes.get("identifier");
        this.styleClass = (String)attributes.get("styleClass");
        this.controlledBy = (String)attributes.get("controlledBy");
        HashMap<String, Object> view = new HashMap<String, Object>();
        view.put("id", this.identifier);
        HashMap<String, Object> widget = new HashMap<String, Object>();
        widget.put("type", "tabs");
        if (this.styleClass != null) {
            widget.put("styleClass", this.styleClass);
        }
        if (null != this.controlledBy) {
            view.put("controllers", this.controlledBy.split(","));
        }
        ArrayList items = new ArrayList();
        for (UIComponent child : this.getChildren()) {
            String switchTo;
            if (!(child instanceof UITab)) continue;
            UITab tab = (UITab)child;
            Map tabAttributes = tab.getAttributes();
            HashMap itemMap = new HashMap();
            itemMap.put("label", tabAttributes.get("label"));
            String link = (String)tabAttributes.get("link");
            if (link != null) {
                itemMap.put("link", link);
            }
            if (null != (switchTo = (String)tabAttributes.get("switchTo"))) {
                itemMap.put("switchTo", switchTo);
            }
            items.add(itemMap);
        }
        widget.put("items", items);
        view.put("widget", widget);
        writer.startElement("ins", (UIComponent)this);
        writer.writeAttribute("class", (Object)"view", null);
        writer.write(Utils.toJson(view));
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("ins");
    }

    public String getControlledBy() {
        return this.controlledBy;
    }

    public void setControlledBy(String controlledBy) {
        this.controlledBy = controlledBy;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }
}

