/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.facelets;

import com.sun.facelets.FaceletFactory;
import com.sun.facelets.FaceletViewHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import org.nuxeo.theme.jsf.facelets.NXThemesFaceletFactory;

public class NXThemesFaceletViewHandler
extends FaceletViewHandler {
    private static final String SEAM_EXPRESSION_FACTORY = "org.jboss.seam.ui.facelet.SeamExpressionFactory";
    private static final long DEFAULT_REFRESH_PERIOD = 2L;
    private static final String PARAM_REFRESH_PERIOD = "facelets.REFRESH_PERIOD";
    private static final String PARAM_RESOURCE_RESOLVER = "facelets.RESOURCE_RESOLVER";

    public NXThemesFaceletViewHandler(ViewHandler parent) {
        super(parent);
    }

    protected Compiler createCompiler() {
        Compiler compiler = super.createCompiler();
        compiler.setFeature("compiler.ExpressionFactory", SEAM_EXPRESSION_FACTORY);
        return compiler;
    }

    protected FaceletFactory createFaceletFactory(Compiler c) {
        long refreshPeriod = 2L;
        FacesContext ctx = FacesContext.getCurrentInstance();
        String userPeriod = ctx.getExternalContext().getInitParameter(PARAM_REFRESH_PERIOD);
        if (userPeriod != null && userPeriod.length() > 0) {
            refreshPeriod = Long.parseLong(userPeriod);
        }
        DefaultResourceResolver resolver = new DefaultResourceResolver();
        String resolverName = ctx.getExternalContext().getInitParameter(PARAM_RESOURCE_RESOLVER);
        if (resolverName != null && resolverName.length() > 0) {
            try {
                resolver = (ResourceResolver)Class.forName(resolverName, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new FacesException("Error Initializing ResourceResolver[" + resolverName + "]", (Throwable)e);
            }
        }
        return new NXThemesFaceletFactory(c, (ResourceResolver)resolver, refreshPeriod);
    }
}

