/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.component;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.nuxeo.theme.jsf.facelets.NXThemesFaceletFactory;

public class UIFragment
extends UIOutput {
    private String uid;
    private String engine;
    private String mode;
    private static final FaceletFactory faceletFactory = new NXThemesFaceletFactory((Compiler)new SAXCompiler(), (ResourceResolver)new DefaultResourceResolver(), -1L);

    public void encodeAll(FacesContext context) throws IOException {
        Map attributes = this.getAttributes();
        this.uid = (String)attributes.get("uid");
        this.engine = (String)attributes.get("engine");
        this.mode = (String)attributes.get("mode");
        ResponseWriter response = context.getResponseWriter();
        UIViewRoot oldViewRoot = context.getViewRoot();
        StringWriter stringWriter = new StringWriter();
        context.setResponseWriter(response.cloneWithWriter((Writer)stringWriter));
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setRendererType(oldViewRoot.getRendererType());
        viewRoot.setRenderKitId(oldViewRoot.getRenderKitId());
        viewRoot.setViewId(oldViewRoot.getViewId());
        viewRoot.setLocale(oldViewRoot.getLocale());
        context.setViewRoot(viewRoot);
        String faceletId = String.format("nxtheme://element/%s/%s/%s", this.engine, this.mode, this.uid);
        Facelet facelet = faceletFactory.getFacelet(faceletId);
        facelet.apply(context, (UIComponent)viewRoot);
        UIFragment.renderChildren(context, (UIComponent)viewRoot);
        response.write(stringWriter.getBuffer().toString());
        context.setResponseWriter(response);
        context.setViewRoot(oldViewRoot);
    }

    public boolean isTransient() {
        return true;
    }

    private static void renderChildren(FacesContext context, UIComponent component) throws IOException {
        List children = component.getChildren();
        for (UIComponent child : children) {
            UIFragment.renderChild(context, child);
        }
    }

    private static void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (child.isRendered()) {
            child.encodeBegin(context);
            if (child.getRendersChildren()) {
                child.encodeChildren(context);
            } else {
                UIFragment.renderChildren(context, child);
            }
            child.encodeEnd(context);
        }
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

