/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.jsf.Utils;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;

public final class Styles
extends HttpServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean RESOLVE_PRESETS = true;
    private static final boolean IGNORE_VIEW_NAME = false;
    private static final boolean IGNORE_CLASSNAME = false;
    private static final boolean INDENT = false;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThemeManager themeManager;
        String rendered;
        ApplicationType application;
        response.addHeader("content-type", "text/css");
        String applicationPath = request.getParameter("path");
        if (applicationPath != null && (application = (ApplicationType)Manager.getTypeRegistry().lookup(TypeFamily.APPLICATION, applicationPath)) != null) {
            Utils.setCacheHeaders(response, application.getStyleCaching());
        }
        Object os = response.getOutputStream();
        if (Utils.supportsGzip(request)) {
            response.setHeader("Content-Encoding", "gzip");
            response.setHeader("Vary", "Accept-Encoding");
            os = new GZIPOutputStream((OutputStream)os);
        }
        if ((rendered = (themeManager = Manager.getThemeManager()).getCachedStyles()) == null) {
            StringBuilder sb = new StringBuilder();
            for (Format format : themeManager.getFormatsByTypeName("style")) {
                Style style = (Style)format;
                sb.append(Utils.styleToCss(style, style.getSelectorViewNames(), true, false, false, false));
            }
            rendered = sb.toString();
            themeManager.setCachedStyles(rendered);
        }
        os.write(rendered.getBytes());
        os.close();
    }
}

