/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.themes.ThemeSerializer;

public final class XmlExport
extends HttpServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(XmlExport.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String xml;
        String themeName = request.getParameter("theme");
        String download = request.getParameter("download");
        String indent = request.getParameter("indent");
        if (themeName == null) {
            return;
        }
        ThemeElement theme = Manager.getThemeManager().getThemeByName(themeName);
        if (theme == null) {
            return;
        }
        ThemeSerializer serializer = new ThemeSerializer();
        int indenting = 0;
        if (indent != null) {
            try {
                indenting = Integer.valueOf(indent);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Incorrect indentation value: " + indent));
            }
        }
        if ((xml = serializer.serializeToXml((Element)theme, indenting)) == null) {
            return;
        }
        response.addHeader("content-type", "text/xml");
        if (download != null) {
            response.addHeader("Content-disposition", String.format("attachment; filename=theme-%s.xml", theme.getName()));
        }
        PrintWriter responseWriter = response.getWriter();
        responseWriter.write(xml);
        responseWriter.flush();
    }
}

