/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.models.InfoPool;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.views.AbstractView;
import org.nuxeo.theme.views.ViewType;

public class JSFView
extends AbstractView {
    private static final Log log = LogFactory.getLog(JSFView.class);
    private static final Pattern firstTagPattern = Pattern.compile("<([a-zA-Z0-9:]*)[^>]*>", 32);
    private static final String[] ALLOWED_TAGS = new String[]{"html", "body", "table", "tr", "td", "div"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String render(RenderingInfo info) {
        String result;
        String template;
        block30: {
            ViewType viewType = this.getViewType();
            template = viewType.getTemplate();
            result = "";
            InputStream is = null;
            try {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
                if (is == null) {
                    log.warn((Object)("View template not found: " + template));
                    break block30;
                }
                Reader in = null;
                try {
                    int ch;
                    in = new BufferedReader(new InputStreamReader(is));
                    StringBuilder rendered = new StringBuilder();
                    while ((ch = in.read()) > -1) {
                        rendered.append((char)ch);
                    }
                    result = rendered.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        try {
                            is.close();
                            is = null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            is = null;
                        }
                    }
                    catch (Throwable throwable) {
                        is = null;
                        throw throwable;
                    }
                }
            }
        }
        result = result.trim();
        Matcher matcher = firstTagPattern.matcher(result);
        if (matcher.find()) {
            String tag = matcher.group(1).toLowerCase();
            boolean found = false;
            for (String allowedTag : ALLOWED_TAGS) {
                if (!tag.equals(allowedTag)) continue;
                found = true;
            }
            if (!found) {
                log.warn((Object)String.format("First HTML tag of view template: %s (<%s>) not one of <html>, <body>, <div>, <table>, <tr>, <td>", template, tag));
            }
        } else {
            log.warn((Object)("First HTML tag of view template: " + template + " not found"));
        }
        String infoId = InfoPool.computeInfoId((RenderingInfo)info);
        result = result.replaceAll("nxthemesInfo.", String.format("nxthemesInfo.map.%s.", infoId));
        return result.replace("[nxthemes markup]", info.getMarkup());
    }
}

