/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.theme.styling.service.descriptors.NegotiatorDescriptor;

@XObject(value="negotiation")
public class NegotiationDescriptor {
    @XNode(value="@target")
    protected String target;
    @XNode(value="@append")
    protected boolean append = false;
    @XNodeList(value="negotiator", type=ArrayList.class, componentType=NegotiatorDescriptor.class)
    List<NegotiatorDescriptor> negotiators;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public List<NegotiatorDescriptor> getNegotiators() {
        ArrayList<NegotiatorDescriptor> res = new ArrayList<NegotiatorDescriptor>();
        if (this.negotiators != null) {
            res.addAll(this.negotiators);
        }
        Collections.sort(res);
        return res;
    }

    public void setNegotiators(List<NegotiatorDescriptor> negotiators) {
        this.negotiators = negotiators;
    }

    public void merge(NegotiationDescriptor src) {
        List<NegotiatorDescriptor> negotiators = src.negotiators;
        if (negotiators != null) {
            List<NegotiatorDescriptor> oldNegotiators;
            boolean keepOld;
            ArrayList<NegotiatorDescriptor> merged = new ArrayList<NegotiatorDescriptor>();
            merged.addAll(negotiators);
            boolean bl = keepOld = src.isAppend() || negotiators.isEmpty() && !src.isAppend();
            if (keepOld && (oldNegotiators = this.negotiators) != null) {
                merged.addAll(0, oldNegotiators);
            }
            this.setNegotiators(merged);
        }
    }

    public NegotiationDescriptor clone() {
        NegotiationDescriptor clone = new NegotiationDescriptor();
        clone.setTarget(this.getTarget());
        clone.setAppend(this.isAppend());
        List<NegotiatorDescriptor> negotiators = this.negotiators;
        if (negotiators != null) {
            ArrayList<NegotiatorDescriptor> cnegociators = new ArrayList<NegotiatorDescriptor>();
            for (NegotiatorDescriptor neg : negotiators) {
                cnegociators.add(neg.clone());
            }
            clone.setNegotiators(cnegociators);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NegotiationDescriptor)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NegotiationDescriptor p = (NegotiationDescriptor)obj;
        return new EqualsBuilder().append((Object)this.target, (Object)p.target).append(this.append, p.append).append(this.negotiators, p.negotiators).isEquals();
    }
}

