/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="themePage")
public class ThemePage {
    @XNode(value="@name")
    String name;
    @XNode(value="defaultFlavor")
    String defaultFlavor;
    @XNode(value="styles@append")
    boolean appendStyles;
    @XNodeList(value="styles/style", type=ArrayList.class, componentType=String.class)
    List<String> styles;
    @XNode(value="flavors@append")
    boolean appendFlavors;
    @XNodeList(value="flavors/flavor", type=ArrayList.class, componentType=String.class)
    List<String> flavors;
    @XNode(value="resources@append")
    boolean appendResources;
    @XNodeList(value="resources/resource", type=ArrayList.class, componentType=String.class)
    List<String> resources;
    boolean loaded = false;

    public String getName() {
        return this.name;
    }

    public String getDefaultFlavor() {
        return this.defaultFlavor;
    }

    public void setDefaultFlavor(String defaultFlavor) {
        this.defaultFlavor = defaultFlavor;
    }

    public boolean getAppendStyles() {
        return this.appendStyles;
    }

    public List<String> getStyles() {
        return this.styles;
    }

    public boolean getAppendFlavors() {
        return this.appendFlavors;
    }

    public List<String> getFlavors() {
        return this.flavors;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStyles(List<String> styles) {
        this.styles = styles;
    }

    public void setFlavors(List<String> flavors) {
        this.flavors = flavors;
    }

    public boolean getAppendResources() {
        return this.appendResources;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setAppendStyles(boolean appendStyles) {
        this.appendStyles = appendStyles;
    }

    public void setAppendFlavors(boolean appendFlavors) {
        this.appendFlavors = appendFlavors;
    }

    public void setAppendResources(boolean appendResources) {
        this.appendResources = appendResources;
    }

    public static String getPageName(String themePage) {
        if ("*".equals(themePage)) {
            return "*";
        }
        try {
            String[] nameEl = themePage.split("/");
            return nameEl[1];
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Invalid theme page name '%s': cannot retrieve page name", themePage));
        }
    }

    public static String getThemeName(String themePage) {
        if ("*".equals(themePage)) {
            return "*";
        }
        try {
            String[] nameEl = themePage.split("/");
            return nameEl[0];
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Invalid theme page name '%s': cannot retrieve theme name", themePage));
        }
    }
}

