/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.nuxeo.targetplatforms.api.TargetPackage;
import org.nuxeo.targetplatforms.api.TargetPackageInfo;
import org.nuxeo.targetplatforms.api.TargetPlatform;
import org.nuxeo.targetplatforms.api.TargetPlatformInfo;
import org.nuxeo.targetplatforms.api.TargetPlatformInstance;

public class JSONExporter {
    public static void exportToJson(TargetPlatform tp, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson((Object)tp, out, pretty);
    }

    public static void exportToJson(List<TargetPlatform> tp, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson(tp, out, pretty);
    }

    public static void exportToJson(TargetPlatformInfo tpi, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson((Object)tpi, out, pretty);
    }

    public static void exportInfosToJson(List<TargetPlatformInfo> tpi, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson(tpi, out, pretty);
    }

    public static void exportToJson(TargetPlatformInstance tpi, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson((Object)tpi, out, pretty);
    }

    public static void exportToJson(TargetPackage tp, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson((Object)tp, out, pretty);
    }

    public static void exportToJson(TargetPackageInfo tpi, OutputStream out, boolean pretty) throws IOException {
        JSONExporter.exportToJson((Object)tpi, out, pretty);
    }

    protected static JsonFactory createFactory() {
        JsonFactory factory = new JsonFactory();
        ObjectMapper oc = new ObjectMapper(factory);
        oc.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        factory.setCodec((ObjectCodec)oc);
        return factory;
    }

    protected static void exportToJson(Object object, OutputStream out, boolean pretty) throws IOException {
        JsonFactory factory = JSONExporter.createFactory();
        try (JsonGenerator jg = factory.createGenerator(out);){
            if (pretty) {
                jg.useDefaultPrettyPrinter();
            }
            jg.writeObject(object);
        }
    }
}

