/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.SubPropertyConverter;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import java.util.List;
import java.util.Map;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;

class BackgroundConverter
extends StyleConverter<ParsedValue[], Background>
implements SubPropertyConverter<Background> {
    static final StyleConverter<ParsedValue[], Background> INSTANCE = new BackgroundConverter();

    BackgroundConverter() {
    }

    @Override
    public Background convert(Map<CssMetaData<? extends Styleable, ?>, Object> map) {
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        boolean bl;
        Paint[] paintArray = (Paint[])map.get(Background.BACKGROUND_COLOR);
        Object[] objectArray2 = (Object[])map.get(Background.BACKGROUND_IMAGE);
        boolean bl2 = paintArray != null && paintArray.length > 0;
        boolean bl3 = bl = objectArray2 != null && objectArray2.length > 0;
        if (!bl2 && !bl) {
            return null;
        }
        BackgroundFill[] backgroundFillArray = null;
        if (bl2) {
            backgroundFillArray = new BackgroundFill[paintArray.length];
            object2 = map.get(Background.BACKGROUND_INSETS);
            object = object2 == null ? new Insets[]{} : (Insets[])object2;
            object2 = map.get(Background.BACKGROUND_RADIUS);
            objectArray = object2 == null ? new CornerRadii[]{} : (CornerRadii[])object2;
            int n2 = ((Insets[])object).length - 1;
            int n3 = objectArray.length - 1;
            for (n = 0; n < paintArray.length; ++n) {
                Insets insets;
                Insets insets2 = ((Insets[])object).length > 0 ? object[n <= n2 ? n : n2] : (insets = Insets.EMPTY);
                CornerRadii cornerRadii = objectArray.length > 0 ? objectArray[n <= n3 ? n : n3] : CornerRadii.EMPTY;
                backgroundFillArray[n] = new BackgroundFill(paintArray[n], cornerRadii, insets);
            }
        }
        object2 = null;
        if (bl) {
            object2 = new BackgroundImage[objectArray2.length];
            object = map.get(Background.BACKGROUND_REPEAT);
            objectArray = object == null ? new RepeatStruct[]{} : (RepeatStruct[])object;
            object = map.get(Background.BACKGROUND_POSITION);
            BackgroundPosition[] backgroundPositionArray = object == null ? new BackgroundPosition[]{} : (BackgroundPosition[])object;
            object = map.get(Background.BACKGROUND_SIZE);
            BackgroundSize[] backgroundSizeArray = object == null ? new BackgroundSize[]{} : (BackgroundSize[])object;
            n = objectArray.length - 1;
            int n4 = backgroundPositionArray.length - 1;
            int n5 = backgroundSizeArray.length - 1;
            for (int i = 0; i < objectArray2.length; ++i) {
                Image image;
                String string;
                if (objectArray2[i] == null) continue;
                Object object3 = objectArray2[i];
                if (object3 instanceof String) {
                    string = (String)object3;
                    image = StyleManager.getInstance().getCachedImage(string);
                } else {
                    object3 = objectArray2[i];
                    if (object3 instanceof Image) {
                        Image image2;
                        image = image2 = (Image)object3;
                    } else {
                        throw new IllegalArgumentException("Unexpected type: " + objectArray2[i].getClass().getName());
                    }
                }
                if (image == null) continue;
                Object object4 = objectArray.length > 0 ? objectArray[i <= n ? i : n] : (string = null);
                Object object5 = backgroundPositionArray.length > 0 ? backgroundPositionArray[i <= n4 ? i : n4] : (object3 = null);
                BackgroundSize backgroundSize = backgroundSizeArray.length > 0 ? backgroundSizeArray[i <= n5 ? i : n5] : null;
                object2[i] = new BackgroundImage(image, string == null ? null : ((RepeatStruct)((Object)string)).repeatX, string == null ? null : ((RepeatStruct)((Object)string)).repeatY, (BackgroundPosition)object3, backgroundSize);
            }
        }
        return new Background(backgroundFillArray, (BackgroundImage[])object2);
    }

    @Override
    public Map<CssMetaData<? extends Styleable, ?>, Object> convertBack(Background background) {
        List<BackgroundFill> list = background.getFills();
        int n = list.size();
        Paint[] paintArray = new Paint[n];
        CornerRadii[] cornerRadiiArray = new CornerRadii[n];
        Insets[] insetsArray = new Insets[n];
        for (int i = 0; i < n; ++i) {
            BackgroundFill backgroundFill = list.get(i);
            paintArray[i] = backgroundFill.getFill();
            cornerRadiiArray[i] = backgroundFill.getRadii();
            insetsArray[i] = backgroundFill.getInsets();
        }
        List<BackgroundImage> list2 = background.getImages();
        int n2 = list2.size();
        Image[] imageArray = new Image[n2];
        BackgroundPosition[] backgroundPositionArray = new BackgroundPosition[n2];
        RepeatStruct[] repeatStructArray = new RepeatStruct[n2];
        BackgroundSize[] backgroundSizeArray = new BackgroundSize[n2];
        for (int i = 0; i < n2; ++i) {
            BackgroundImage backgroundImage = list2.get(i);
            imageArray[i] = backgroundImage.getImage();
            backgroundPositionArray[i] = backgroundImage.getPosition();
            repeatStructArray[i] = new RepeatStruct(backgroundImage.getRepeatX(), backgroundImage.getRepeatY());
            backgroundSizeArray[i] = backgroundImage.getSize();
        }
        return Map.of(Background.BACKGROUND_COLOR, paintArray, Background.BACKGROUND_IMAGE, imageArray, Background.BACKGROUND_INSETS, insetsArray, Background.BACKGROUND_POSITION, backgroundPositionArray, Background.BACKGROUND_RADIUS, cornerRadiiArray, Background.BACKGROUND_REPEAT, repeatStructArray, Background.BACKGROUND_SIZE, backgroundSizeArray);
    }
}

