/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.expr;

import fj.data.Option;
import fj.data.Validation;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.MethodAccess;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

class MethodAccessBase
extends Top.Base
implements MethodAccess {
    private final Cursor cursor;
    private final J.MethodInvocation methodInvocation;

    @Override
    public String getSimpleName() {
        return this.methodInvocation.getSimpleName();
    }

    @Override
    public List<Expr> getArguments() {
        return this.methodInvocation.getArguments().stream().map(e -> (Expr)Expr.viewOf(new Cursor(this.cursor, e)).on(TraitErrors::doThrow)).collect(Collectors.toList());
    }

    @Override
    public boolean matches(InvocationMatcher callMatcher) {
        return callMatcher.matches((MethodCall)this.methodInvocation);
    }

    @Override
    public Option<JavaType.Method> getMethodType() {
        return Option.fromNull((Object)this.methodInvocation.getMethodType());
    }

    static Validation<TraitErrors, MethodAccessBase> viewOf(Cursor cursor) {
        Objects.requireNonNull(cursor, "cursor must not be null");
        return Validation.success((Object)new MethodAccessBase(cursor, (J.MethodInvocation)cursor.getValue()));
    }

    @Override
    public UUID getId() {
        return this.methodInvocation.getId();
    }

    @Generated
    public MethodAccessBase(Cursor cursor, J.MethodInvocation methodInvocation) {
        this.cursor = cursor;
        this.methodInvocation = methodInvocation;
    }
}

