/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ObfuscationRecipe
extends Recipe {
    private static final Pattern OBFUSCATED_EXPRESSION_PATTERN = Pattern.compile("\\$\\{\\{[^}]*['\"]}|['\"]{2,}|\\{\\{[^}]*\\$");

    public String getDisplayName() {
        return "Find obfuscated GitHub Actions features";
    }

    public String getDescription() {
        return "Find workflows that use obfuscated action references or expressions that may be attempting to hide malicious behavior. This includes action paths with `'.'`, `'..'`, empty components, or expressions that use quote manipulation to hide their true intent. Based on [zizmor's `obfuscation` audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/obfuscation.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new ObfuscationVisitor());
    }

    @Generated
    public ObfuscationRecipe() {
    }

    @Generated
    public String toString() {
        return "ObfuscationRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObfuscationRecipe)) {
            return false;
        }
        ObfuscationRecipe other = (ObfuscationRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObfuscationRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class ObfuscationVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private ObfuscationVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isUsesEntry(mappingEntry)) {
                return this.checkUsesEntry(mappingEntry);
            }
            if (this.isRunEntry(mappingEntry)) {
                return this.checkRunEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "uses".equals(key.getValue());
        }

        private boolean isRunEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            Yaml.Scalar key = (Yaml.Scalar)entry.getKey();
            return "run".equals(key.getValue());
        }

        private Yaml.Mapping.Entry checkUsesEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String usesValue = ((Yaml.Scalar)entry.getValue()).getValue();
            if (usesValue.startsWith("./") || usesValue.startsWith("docker://")) {
                return entry;
            }
            if (this.hasObfuscatedPath(usesValue)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Action reference contains obfuscated path components that may hide the actual action being used.");
            }
            return entry;
        }

        private Yaml.Mapping.Entry checkRunEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getValue() instanceof Yaml.Scalar)) {
                return entry;
            }
            String runCommand = ((Yaml.Scalar)entry.getValue()).getValue();
            if (this.hasObfuscatedExpressions(runCommand)) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry, (String)"Contains potentially obfuscated GitHub Actions expressions that may be attempting to hide malicious code.");
            }
            return entry;
        }

        private boolean hasObfuscatedPath(String usesValue) {
            String[] pathParts;
            String[] parts = usesValue.split("@", 2);
            if (parts.length < 2) {
                return false;
            }
            String actionPath = parts[0];
            if (actionPath.contains("//")) {
                return true;
            }
            for (String component : pathParts = actionPath.split("/")) {
                if (".".equals(component)) {
                    return true;
                }
                if (!"..".equals(component)) continue;
                return true;
            }
            return false;
        }

        private boolean hasObfuscatedExpressions(String content) {
            return OBFUSCATED_EXPRESSION_PATTERN.matcher(content).find();
        }
    }
}

