/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MigrateBooleanMappings
extends Recipe {
    private static final Map<String, String> REPLACEMENTS = new HashMap<String, String>();

    public String getDisplayName() {
        return "Replace boolean type mappings with converters";
    }

    public String getDescription() {
        return "Replaces type mapping of booleans with appropriate attribute converters.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.hibernate.annotations.Type", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation ann = super.visitAnnotation(annotation, (Object)ctx);
                if (!TypeUtils.isOfClassType((JavaType)ann.getType(), (String)"org.hibernate.annotations.Type")) {
                    return ann;
                }
                List args = ann.getArguments();
                if (args == null) {
                    return ann;
                }
                Object type = args.stream().filter(exp -> {
                    if (exp instanceof J.Assignment) {
                        J.Identifier variable = (J.Identifier)((J.Assignment)exp).getVariable();
                        return "type".equals(variable.getSimpleName());
                    }
                    return false;
                }).findFirst().map(exp -> {
                    Expression value = ((J.Assignment)exp).getAssignment();
                    if (value instanceof J.Literal) {
                        return ((J.Literal)value).getValue();
                    }
                    return null;
                }).orElse(null);
                if (type instanceof String && REPLACEMENTS.containsKey(type)) {
                    String converterName = (String)REPLACEMENTS.get(type);
                    String converterFQN = String.format("org.hibernate.type.%s", converterName);
                    ann = (J.Annotation)JavaTemplate.builder((String)String.format("@Convert(converter = %s.class)", converterName)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"hibernate-core-6+", "jakarta.persistence-api"})).imports(new String[]{converterFQN, "jakarta.persistence.Convert"}).contextSensitive().build().apply(this.getCursor(), ann.getCoordinates().replace(), new Object[0]);
                    this.maybeRemoveImport("org.hibernate.annotations.Type");
                    this.maybeAddImport("jakarta.persistence.Convert");
                    this.maybeAddImport(converterFQN);
                }
                return ann;
            }
        });
    }

    static {
        REPLACEMENTS.put("org.hibernate.type.TrueFalseBooleanType", "TrueFalseConverter");
        REPLACEMENTS.put("true_false", "TrueFalseConverter");
        REPLACEMENTS.put("org.hibernate.type.YesNoBooleanType", "YesNoConverter");
        REPLACEMENTS.put("yes_no", "YesNoConverter");
        REPLACEMENTS.put("org.hibernate.type.NumericBooleanType", "NumericBooleanConverter");
        REPLACEMENTS.put("numeric_boolean", "NumericBooleanConverter");
    }
}

