/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class TypeAnnotationParameter
extends Recipe {
    private static final String ORG_HIBERNATE_ANNOTATIONS_TYPE = "org.hibernate.annotations.Type";
    private static final AnnotationMatcher FQN_TYPE_ANNOTATION = new AnnotationMatcher("@org.hibernate.annotations.Type");
    private static final String ORG_HIBERNATE_ANNOTATIONS_TYPEDEF = "org.hibernate.annotations.TypeDef";
    private static final AnnotationMatcher FQN_TYPEDEF_ANNOTATION = new AnnotationMatcher("@org.hibernate.annotations.TypeDef");
    private static final String ORG_HIBERNATE_ANNOTATIONS_TYPEDEFS = "org.hibernate.annotations.TypeDefs";
    private static final AnnotationMatcher FQN_TYPEDEFS_ANNOTATION = new AnnotationMatcher("@org.hibernate.annotations.TypeDefs");
    private static final Set<String> REMOVED_FQNS = new HashSet<String>(Arrays.asList("org.hibernate.type.EnumType", "org.hibernate.type.SerializableType", "org.hibernate.type.SerializableToBlobType", "org.hibernate.type.TextType"));

    public String getDisplayName() {
        return "`@Type` annotation type parameter migration";
    }

    public String getDescription() {
        return "Hibernate 6.x has 'type' parameter of type String replaced with 'value' of type class.";
    }

    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ORG_HIBERNATE_ANNOTATIONS_TYPE, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                if (FQN_TYPEDEF_ANNOTATION.matches(a)) {
                    Expression name = this.getAttributeValue(annotation, "name");
                    if (name instanceof J.Literal) {
                        String alias = (String)((J.Literal)name).getValue();
                        Expression typeClass = this.getAttributeValue(annotation, "typeClass");
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, alias, (Object)typeClass);
                    }
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPEDEF);
                    this.removeTypeDefAnnotations(a);
                    return a;
                }
                if (FQN_TYPEDEFS_ANNOTATION.matches(a)) {
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPEDEFS);
                    this.removeTypeDefAnnotations(a);
                    return a;
                }
                if (!FQN_TYPE_ANNOTATION.matches(a)) {
                    return a;
                }
                if (a.getArguments() != null && a.getArguments().stream().anyMatch(arg -> {
                    J.Assignment assignment;
                    if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                        String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                        return REMOVED_FQNS.contains(fqTypeName);
                    }
                    return false;
                })) {
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPE);
                    return null;
                }
                AtomicReference<String> temporalType = this.getTemporalTypeArgument(a);
                if (temporalType.get() != null) {
                    this.maybeRemoveImport(TypeAnnotationParameter.ORG_HIBERNATE_ANNOTATIONS_TYPE);
                    this.maybeAddImport("jakarta.persistence.Temporal");
                    this.maybeAddImport("jakarta.persistence.TemporalType");
                    return (J.Annotation)JavaTemplate.builder((String)("@Temporal(TemporalType." + temporalType.get().toUpperCase() + ")")).doBeforeParseTemplate(System.out::println).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jakarta.persistence-api"})).imports(new String[]{"jakarta.persistence.Temporal", "jakarta.persistence.TemporalType"}).build().apply(this.getCursor(), a.getCoordinates().replace(), new Object[0]);
                }
                return this.replaceArgumentWithClass(a);
            }

            private @Nullable Expression getAttributeValue(J.Annotation annotation, String attributeName) {
                if (annotation.getArguments() != null) {
                    for (Expression arg : annotation.getArguments()) {
                        J.Assignment assignment;
                        if (!(arg instanceof J.Assignment) || !((assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier) || !attributeName.equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                        return assignment.getAssignment();
                    }
                }
                return null;
            }

            private AtomicReference<@Nullable String> getTemporalTypeArgument(J.Annotation a) {
                return (AtomicReference)new JavaIsoVisitor<AtomicReference<String>>(){

                    public J.Assignment visitAssignment(J.Assignment assignment, AtomicReference<@Nullable String> ref) {
                        J.Assignment as = super.visitAssignment(assignment, ref);
                        if (J.Literal.isLiteralValue((Expression)as.getAssignment(), (Object)"date") || J.Literal.isLiteralValue((Expression)as.getAssignment(), (Object)"time") || J.Literal.isLiteralValue((Expression)as.getAssignment(), (Object)"timestamp")) {
                            ref.set((String)((J.Literal)as.getAssignment()).getValue());
                        }
                        return as;
                    }
                }.reduce((Tree)a, new AtomicReference());
            }

            private J.Annotation replaceArgumentWithClass(J.Annotation a) {
                boolean isOnlyParameter = a.getArguments() != null && a.getArguments().size() == 1;
                return a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                    J.Assignment assignment;
                    if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                        Expression classRef;
                        String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                        Expression nearestMessage = (Expression)this.getCursor().getNearestMessage(fqTypeName);
                        Expression expression = nearestMessage != null && nearestMessage.getType() != JavaType.Unknown.getInstance() ? nearestMessage : (classRef = this.buildClassReference(nearestMessage != null ? TypeAnnotationParameter.getFullyQualifiedTypeName(nearestMessage) : fqTypeName, isOnlyParameter ? Space.EMPTY : assignment.getAssignment().getPrefix()));
                        if (isOnlyParameter) {
                            return (Expression)classRef.withPrefix(Space.EMPTY);
                        }
                        return assignment.withVariable((Expression)((J.Identifier)assignment.getVariable()).withSimpleName("value")).withAssignment(classRef);
                    }
                    return arg;
                }));
            }

            private J.FieldAccess buildClassReference(String fullyQualifiedName, Space prefix) {
                String[] parts = fullyQualifiedName.split("\\.");
                J.Identifier identifier = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), parts[parts.length - 1], JavaType.buildType((String)fullyQualifiedName), null);
                this.maybeAddImport(fullyQualifiedName);
                return new J.FieldAccess(Tree.randomId(), prefix, Markers.EMPTY, (Expression)identifier, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "class", null, null)), JavaType.buildType((String)"java.lang.Class"));
            }

            private void removeTypeDefAnnotations(final J.Annotation typeDefAnnotation) {
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(new AnnotationMatcher("@org.hibernate.annotations.TypeDef*"){

                    public boolean matches(J.Annotation a) {
                        if (a == typeDefAnnotation) {
                            return true;
                        }
                        if (FQN_TYPEDEFS_ANNOTATION.matches(a)) {
                            return a.getArguments() == null || a.getArguments().isEmpty() || a.getArguments().get(0) instanceof J.Empty;
                        }
                        return false;
                    }
                }));
            }
        });
    }

    private static @Nullable String getFullyQualifiedTypeName(Expression expr) {
        if (expr instanceof J.FieldAccess) {
            String fqName = ((J.FieldAccess)expr).toString();
            return fqName.endsWith(".class") ? fqName.substring(0, fqName.length() - 6) : fqName;
        }
        return null;
    }
}

