/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public class Jackson3JsonNodeFieldIterators
extends Recipe {
    private static final MethodMatcher FIELDS = new MethodMatcher("com.fasterxml.jackson.databind.JsonNode fields()");
    private static final MethodMatcher FIELDS_NAMES = new MethodMatcher("com.fasterxml.jackson.databind.JsonNode fieldNames()");
    private static final MethodMatcher ELEMENTS = new MethodMatcher("com.fasterxml.jackson.databind.JsonNode elements()");

    public String getDisplayName() {
        return "Migrate `JSONNode` field iterator for Jackson 3";
    }

    public String getDescription() {
        return "`JSONNode` fields are using `Collections` instead of `Iterator` singe Jackson 3. To mimic Jackson 2s behavior an additional call to `Collection#iterator()`is needed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(FIELDS), new UsesMethod(FIELDS_NAMES), new UsesMethod(ELEMENTS)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (FIELDS.matches((MethodCall)mi)) {
                    this.doAfterVisit(new ChangeMethodName("com.fasterxml.jackson.databind.JsonNode fields()", "properties", null, null).getVisitor());
                    return this.addCallToChain("java.util.Collections.<String, JsonNode>emptyMap().entrySet().iterator()", mi);
                }
                if (FIELDS_NAMES.matches((MethodCall)mi)) {
                    this.doAfterVisit(new ChangeMethodName("com.fasterxml.jackson.databind.JsonNode fieldNames()", "propertyNames", null, null).getVisitor());
                    return this.addCallToChain("java.util.Collections.<String>emptySet().iterator()", mi);
                }
                if (ELEMENTS.matches((MethodCall)mi)) {
                    this.doAfterVisit(new ChangeMethodName("com.fasterxml.jackson.databind.JsonNode elements()", "values", null, null).getVisitor());
                    return this.addCallToChain("java.util.Collections.<JsonNode>emptySet().iterator()", mi);
                }
                return mi;
            }

            private J.MethodInvocation addCallToChain(String template, J.MethodInvocation mi) {
                J.MethodInvocation iteratorCall = (J.MethodInvocation)JavaTemplate.apply((String)template, (Cursor)this.updateCursor((Tree)mi), (JavaCoordinates)mi.getCoordinates().replace(), (Object[])new Object[0]);
                return iteratorCall.withSelect((Expression)mi).withPrefix(Space.EMPTY);
            }
        });
    }
}

