/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

public class SimplifyJacksonExceptionCatch
extends Recipe {
    private static final String RUNTIME_EXCEPTION = "java.lang.RuntimeException";
    private static final String JACKSON_RUNTIME_EXCEPTION = "tools.jackson.core.JacksonException";

    public String getDisplayName() {
        return "Simplify catch clauses for Jackson exceptions";
    }

    public String getDescription() {
        return "In Jackson 3, `JacksonException` and its subtypes extend `RuntimeException`. This recipe simplifies multi-catch clauses by removing Jackson exception types when `RuntimeException` is also caught, since catching both is redundant. For example, `catch (JacksonException | RuntimeException e)` becomes `catch (RuntimeException e)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("jackson-3");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(JACKSON_RUNTIME_EXCEPTION, Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, ExecutionContext ctx) {
                J.MultiCatch mc = super.visitMultiCatch(multiCatch, (Object)ctx);
                if (mc.getAlternatives().stream().noneMatch(nt -> TypeUtils.isOfClassType((JavaType)nt.getType(), (String)SimplifyJacksonExceptionCatch.RUNTIME_EXCEPTION))) {
                    return mc;
                }
                List filtered = ListUtils.filter((List)mc.getAlternatives(), nt -> {
                    if (TypeUtils.isAssignableTo((String)SimplifyJacksonExceptionCatch.JACKSON_RUNTIME_EXCEPTION, (JavaType)nt.getType())) {
                        this.maybeRemoveImport(TypeUtils.asFullyQualified((JavaType)nt.getType()));
                        return false;
                    }
                    return true;
                });
                return mc.withAlternatives(ListUtils.mapFirst((List)filtered, first -> (NameTree)first.withPrefix(((NameTree)mc.getAlternatives().get(0)).getPrefix())));
            }
        });
    }
}

