/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaIterablesAll
extends Recipe {
    private static final MethodMatcher ITERABLES_ALL = new MethodMatcher("com.google.common.collect.Iterables all(java.lang.Iterable, com.google.common.base.Predicate)");

    public String getDisplayName() {
        return "Prefer `Collection.stream().allMatch(Predicate)`";
    }

    public String getDescription() {
        return "Prefer `Collection.stream().allMatch(Predicate)` over `Iterables.all(Collection, Predicate)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ITERABLES_ALL), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (ITERABLES_ALL.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicate");
                    this.maybeRemoveImport("com.google.common.collect.Iterables");
                    this.maybeAddImport("java.util.function.Predicate");
                    if (TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                        return JavaTemplate.builder((String)"#{any(java.util.Collection)}.stream().allMatch(#{any(java.util.function.Predicate)})").build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                    }
                    return method;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

