/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaOptionalAsSet
extends Recipe {
    private static final MethodMatcher OPTIONAL_AS_SET = new MethodMatcher("com.google.common.base.Optional asSet()");

    public String getDisplayName() {
        return "Prefer `Optional.stream().collect(Collectors.toSet())`";
    }

    public String getDescription() {
        return "Prefer `Optional.stream().collect(Collectors.toSet())` over `Optional.asSet()`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(OPTIONAL_AS_SET), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (OPTIONAL_AS_SET.matches((MethodCall)method)) {
                    this.maybeAddImport("java.util.stream.Collectors");
                    return JavaTemplate.builder((String)"#{any(java.util.Optional)}.stream().collect(Collectors.toSet())").imports(new String[]{"java.util.stream.Collectors"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

