/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis.maven;

import java.text.Normalizer;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;

public final class MavenJavadocNonAsciiRecipe
extends Recipe {
    public String getDisplayName() {
        return "Remove non-ASCII characters from Javadoc";
    }

    public String getDescription() {
        return "Maven's javadoc-plugin configuration does not support non-ASCII characters. What makes it tricky is the error is very ambiguous and doesn't help in any way. This recipe removes those non-ASCII characters.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public Space visitSpace(@Nullable Space space, Space.Location loc, ExecutionContext ctx) {
                Space sp = super.visitSpace(space, loc, (Object)ctx);
                return sp.withComments(ListUtils.map((List)sp.getComments(), c -> {
                    if (c instanceof Javadoc.DocComment) {
                        Javadoc.DocComment jdc = (Javadoc.DocComment)c;
                        return jdc.withBody(ListUtils.map((List)jdc.getBody(), jd -> {
                            if (jd instanceof Javadoc.Text) {
                                Javadoc.Text jdText = (Javadoc.Text)jd;
                                String newText = Normalizer.normalize(jdText.getText(), Normalizer.Form.NFKD).replaceAll("[^\\p{ASCII}]", "");
                                return jdText.getText().equals(newText) ? jd : jdText.withText(newText);
                            }
                            return jd;
                        }));
                    }
                    return c;
                }));
            }
        };
    }

    @Generated
    public MavenJavadocNonAsciiRecipe() {
    }

    @Generated
    public String toString() {
        return "MavenJavadocNonAsciiRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenJavadocNonAsciiRecipe)) {
            return false;
        }
        MavenJavadocNonAsciiRecipe other = (MavenJavadocNonAsciiRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MavenJavadocNonAsciiRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

