/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Literal;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public class JUnitParamsRunnerToParameterized
extends Recipe {
    private static final AnnotationMatcher RUN_WITH_JUNIT_PARAMS_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.runner.RunWith(junitparams.JUnitParamsRunner.class)");
    private static final AnnotationMatcher JUNIT_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.Test");
    private static final AnnotationMatcher JUPITER_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher PARAMETERS_MATCHER = new AnnotationMatcher("@junitparams.Parameters");
    private static final AnnotationMatcher TEST_CASE_NAME_MATCHER = new AnnotationMatcher("@junitparams.naming.TestCaseName");
    private static final AnnotationMatcher NAMED_PARAMETERS_MATCHER = new AnnotationMatcher("@junitparams.NamedParameters");
    private static final AnnotationMatcher CONVERTER_MATCHER = new AnnotationMatcher("@junitparams.converters.Param");
    private static final String INIT_METHOD_REFERENCES = "init-method-references";
    private static final String CSV_PARAMS = "csv-params";
    private static final String PARAMETERS_FOR_PREFIX = "parametersFor";
    private static final String PARAMETERIZED_TESTS = "parameterized-tests";
    private static final String INIT_METHODS_MAP = "named-parameters-map";
    private static final String CONVERSION_NOT_SUPPORTED = "conversion-not-supported";

    public String getDisplayName() {
        return "Pragmatists `@RunWith(JUnitParamsRunner.class)` to JUnit Jupiter `@Parameterized` tests";
    }

    public String getDescription() {
        return "Convert Pragmatists Parameterized test to the JUnit Jupiter ParameterizedTest equivalent.";
    }

    private static String junitParamsDefaultInitMethodName(String methodName) {
        return PARAMETERS_FOR_PREFIX + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("junitparams.*", Boolean.valueOf(false)), (TreeVisitor)new ParameterizedTemplateVisitor());
    }

    private static class ParameterizedTemplateVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ParameterizedTemplateVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            Set initMethods = (Set)this.getCursor().computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet());
            Boolean hasCsvParams = (Boolean)this.getCursor().getMessage(JUnitParamsRunnerToParameterized.CSV_PARAMS);
            if (!initMethods.isEmpty() || Boolean.TRUE.equals(hasCsvParams)) {
                this.doAfterVisit((TreeVisitor)new ParametersNoArgsImplicitMethodSource(initMethods, (Map)this.getCursor().computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHODS_MAP, v -> new HashMap()), (Set)this.getCursor().computeMessageIfAbsent(JUnitParamsRunnerToParameterized.CONVERSION_NOT_SUPPORTED, v -> new HashSet()), (Set)this.getCursor().computeMessageIfAbsent(JUnitParamsRunnerToParameterized.PARAMETERIZED_TESTS, v -> new HashSet()), ctx));
            }
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            if (m.getSimpleName().startsWith(JUnitParamsRunnerToParameterized.PARAMETERS_FOR_PREFIX)) {
                ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet())).add(m.getSimpleName());
            }
            return m;
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
            Annotated annotated;
            Optional value;
            J.Annotation anno = super.visitAnnotation(annotation, (Object)ctx);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            if (PARAMETERS_MATCHER.matches(anno)) {
                Annotated annotated2 = (Annotated)new Annotated.Matcher(PARAMETERS_MATCHER).require((Tree)annotation, this.getCursor().getParentOrThrow());
                String annotationArgumentValue = this.getAnnotationArgumentForInitMethod(annotated2, "method", "named");
                ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.PARAMETERIZED_TESTS, v -> new HashSet())).add(((J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class)).getSimpleName());
                if (annotationArgumentValue != null) {
                    for (String method : annotationArgumentValue.split(",")) {
                        ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet())).add(method);
                    }
                } else if (this.isSupportedCsvParam(annotated2)) {
                    anno = (J.Annotation)ParameterizedTemplateVisitor.getCsVParamTemplate(ctx).apply(this.updateCursor((Tree)anno), anno.getCoordinates().replace(), new Object[]{anno.getArguments().get(0)});
                    classDeclCursor.putMessage(JUnitParamsRunnerToParameterized.CSV_PARAMS, (Object)Boolean.TRUE);
                } else if (anno.getArguments() != null && !anno.getArguments().isEmpty()) {
                    String comment = " JunitParamsRunnerToParameterized conversion not supported";
                    if (anno.getComments().stream().noneMatch(c -> c.printComment(this.getCursor()).endsWith(comment))) {
                        anno = (J.Annotation)anno.withComments(ListUtils.concat((List)anno.getComments(), (Object)new TextComment(false, comment, "\n" + anno.getPrefix().getIndent(), Markers.EMPTY)));
                    }
                    J.MethodDeclaration m = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                    Set unsupportedMethods = (Set)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.CONVERSION_NOT_SUPPORTED, v -> new HashSet());
                    unsupportedMethods.add(m.getSimpleName());
                    unsupportedMethods.add(JUnitParamsRunnerToParameterized.junitParamsDefaultInitMethodName(m.getSimpleName()));
                }
            } else if (NAMED_PARAMETERS_MATCHER.matches(annotation)) {
                Annotated annotated3 = (Annotated)new Annotated.Matcher(NAMED_PARAMETERS_MATCHER).require((Tree)annotation, this.getCursor().getParentOrThrow());
                Optional value2 = annotated3.getDefaultAttribute("value");
                if (value2.isPresent()) {
                    J.MethodDeclaration m = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                    ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet())).add(m.getSimpleName());
                    ((HashMap)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHODS_MAP, v -> new HashMap())).put(((Literal)value2.get()).getString(), m.getSimpleName());
                }
            } else if (TEST_CASE_NAME_MATCHER.matches(anno) && (value = (annotated = (Annotated)new Annotated.Matcher(TEST_CASE_NAME_MATCHER).require((Tree)annotation, this.getCursor().getParentOrThrow())).getDefaultAttribute("value")).isPresent()) {
                String testNameArg = ((Literal)value.get()).getString();
                String testName = testNameArg != null ? testNameArg.toString() : "{method}({params}) [{index}]";
                J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                ((HashMap)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHODS_MAP, v -> new HashMap())).put(md.getSimpleName(), testName);
            }
            return anno;
        }

        private @Nullable String getAnnotationArgumentForInitMethod(Annotated annotated, String ... variableNames) {
            for (String variableName : variableNames) {
                Optional attribute = annotated.getAttribute(variableName);
                if (!attribute.isPresent()) continue;
                return ((Literal)attribute.get()).getString();
            }
            return null;
        }

        private boolean isSupportedCsvParam(Annotated annotated) {
            if (((J.Annotation)annotated.getTree()).getArguments() == null || ((J.Annotation)annotated.getTree()).getArguments().size() != 1) {
                return false;
            }
            Optional value = annotated.getDefaultAttribute("value");
            return value.isPresent() && ((Literal)value.get()).isArray() && !this.doTestParamsHaveCustomConverter((J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class));
        }

        private boolean doTestParamsHaveCustomConverter(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.MethodDeclaration method) {
            if (method == null) {
                return false;
            }
            return method.getParameters().stream().filter(param -> param instanceof J.VariableDeclarations).map(J.VariableDeclarations.class::cast).anyMatch(v -> v.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)CONVERTER_MATCHER).matches(arg_0)));
        }

        private static JavaTemplate getCsVParamTemplate(ExecutionContext ctx) {
            return JavaTemplate.builder((String)"@CsvSource(#{any(java.lang.String[])})").imports(new String[]{"org.junit.jupiter.params.provider.CsvSource"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-params"})).build();
        }
    }

    private static class MakeMethodStatic
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String REFERENCED_METHODS = "referencedMethods";
        private final JavaType.FullyQualified classType;
        private final List<String> methodNames;

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
            if (classDeclaration.getType() != this.classType) {
                return classDeclaration;
            }
            J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
            List methodNames = (List)this.getCursor().getMessage(REFERENCED_METHODS, Collections.emptyList());
            if (!methodNames.isEmpty()) {
                this.doAfterVisit((TreeVisitor)new MakeMethodStatic(this.classType, methodNames));
            }
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (!this.methodNames.contains(method.getSimpleName()) || method.hasModifier(J.Modifier.Type.Static) || method.getMethodType() == null || method.getMethodType().getDeclaringType() != this.classType) {
                return method;
            }
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            J.Modifier staticModifier = new J.Modifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, null, J.Modifier.Type.Static, new ArrayList());
            return m.withModifiers(ListUtils.concat((List)m.getModifiers(), (Object)staticModifier));
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodDeclaration enclosingMethod = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
            if (enclosingMethod != null && method.getMethodType() != null && this.methodNames.contains(enclosingMethod.getSimpleName()) && method.getMethodType().getDeclaringType() == this.classType) {
                Cursor classCursor = this.getCursor().dropParentUntil(j -> j instanceof J.ClassDeclaration);
                ((ArrayList)classCursor.computeMessageIfAbsent(REFERENCED_METHODS, k -> new ArrayList())).add(method.getSimpleName());
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        @ConstructorProperties(value={"classType", "methodNames"})
        @Generated
        public MakeMethodStatic(JavaType.FullyQualified classType, List<String> methodNames) {
            this.classType = classType;
            this.methodNames = methodNames;
        }
    }

    private static class ParametersNoArgsImplicitMethodSource
    extends JavaIsoVisitor<ExecutionContext> {
        private final Set<String> initMethods;
        private final Set<String> unsupportedConversions;
        private final Set<String> parameterizedTests;
        private final Map<String, String> initMethodReferences;
        private final JavaTemplate parameterizedTestTemplate;
        private final JavaTemplate parameterizedTestTemplateWithName;
        private final JavaTemplate methodSourceTemplate;

        public ParametersNoArgsImplicitMethodSource(Set<String> initMethods, Map<String, String> initMethodReferences, Set<String> unsupportedConversions, Set<String> parameterizedTests, ExecutionContext ctx) {
            this.initMethods = initMethods;
            this.initMethodReferences = initMethodReferences;
            this.unsupportedConversions = unsupportedConversions;
            this.parameterizedTests = parameterizedTests;
            JavaParser.Builder javaParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "hamcrest-3", "junit-jupiter-params-5"});
            this.parameterizedTestTemplate = JavaTemplate.builder((String)"@ParameterizedTest").javaParser(javaParser).imports(new String[]{"org.junit.jupiter.params.ParameterizedTest"}).build();
            this.parameterizedTestTemplateWithName = JavaTemplate.builder((String)"@ParameterizedTest(name = \"#{}\")").javaParser(javaParser).imports(new String[]{"org.junit.jupiter.params.ParameterizedTest"}).build();
            this.methodSourceTemplate = JavaTemplate.builder((String)"@MethodSource(#{})").javaParser(javaParser).imports(new String[]{"org.junit.jupiter.params.provider.MethodSource"}).build();
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(RUN_WITH_JUNIT_PARAMS_ANNOTATION_MATCHER));
            List methodNames = (List)this.getCursor().getMessage("referencedMethods", Collections.emptyList());
            if (cd.getType() != null && !methodNames.isEmpty()) {
                this.doAfterVisit((TreeVisitor)new MakeMethodStatic(cd.getType(), methodNames));
            }
            this.maybeRemoveImport("org.junit.Test");
            this.maybeRemoveImport("org.junit.jupiter.api.Test");
            this.maybeRemoveImport("org.junit.runner.RunWith");
            this.maybeRemoveImport("junitparams.JUnitParamsRunner");
            this.maybeRemoveImport("junitparams.Parameters");
            this.maybeRemoveImport("junitparams.NamedParameters");
            this.maybeRemoveImport("junitparams.naming.TestCaseName");
            this.maybeAddImport("org.junit.jupiter.params.ParameterizedTest");
            this.maybeAddImport("org.junit.jupiter.params.provider.MethodSource");
            this.maybeAddImport("org.junit.jupiter.params.provider.CsvSource");
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m;
            block5: {
                block4: {
                    if (this.unsupportedConversions.contains(method.getSimpleName())) {
                        return method;
                    }
                    m = super.visitMethodDeclaration(method, (Object)ctx);
                    String paramTestName = this.initMethodReferences.get(m.getSimpleName());
                    List annotations = ListUtils.map((List)m.getLeadingAnnotations(), anno -> {
                        if (TEST_CASE_NAME_MATCHER.matches(anno) || NAMED_PARAMETERS_MATCHER.matches(anno)) {
                            return null;
                        }
                        anno = this.maybeReplaceTestAnnotation(new Cursor(this.getCursor(), anno), paramTestName);
                        anno = this.maybeReplaceParametersAnnotation(new Cursor(this.getCursor(), anno), method.getSimpleName());
                        return anno;
                    });
                    if (this.initMethods.contains((m = m.withLeadingAnnotations(annotations)).getSimpleName())) break block4;
                    if (!this.initMethodReferences.containsValue(m.getSimpleName())) break block5;
                }
                Cursor enclosingCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
                ((ArrayList)enclosingCursor.computeMessageIfAbsent("referencedMethods", k -> new ArrayList())).add(m.getSimpleName());
            }
            return (J.MethodDeclaration)this.maybeAutoFormat((J)method, (J)m, (J)m.getName(), ctx, this.getCursor().getParentTreeCursor());
        }

        private J.Annotation maybeReplaceTestAnnotation(Cursor anno, @Nullable String parameterizedTestArgument) {
            if (JUPITER_TEST_ANNOTATION_MATCHER.matches((J.Annotation)anno.getValue()) || JUNIT_TEST_ANNOTATION_MATCHER.matches((J.Annotation)anno.getValue())) {
                if (!this.parameterizedTests.contains(((J.MethodDeclaration)anno.firstEnclosing(J.MethodDeclaration.class)).getSimpleName())) {
                    return (J.Annotation)anno.getValue();
                }
                if (parameterizedTestArgument == null) {
                    return (J.Annotation)this.parameterizedTestTemplate.apply(anno, ((J.Annotation)anno.getValue()).getCoordinates().replace(), new Object[0]);
                }
                return (J.Annotation)this.parameterizedTestTemplateWithName.apply(anno, ((J.Annotation)anno.getValue()).getCoordinates().replace(), new Object[]{parameterizedTestArgument});
            }
            return (J.Annotation)anno.getValue();
        }

        private J.Annotation maybeReplaceParametersAnnotation(Cursor anno, String methodName) {
            if (PARAMETERS_MATCHER.matches((J.Annotation)anno.getValue())) {
                String initMethodName = JUnitParamsRunnerToParameterized.junitParamsDefaultInitMethodName(methodName);
                if (this.initMethods.contains(initMethodName)) {
                    return (J.Annotation)this.methodSourceTemplate.apply(anno, ((J.Annotation)anno.getValue()).getCoordinates().replace(), new Object[]{"\"" + initMethodName + "\""});
                }
                String annotationArg = this.getAnnotationArgumentValueForMethodTemplate((J.Annotation)anno.getValue());
                if (annotationArg != null) {
                    return (J.Annotation)this.methodSourceTemplate.apply(anno, ((J.Annotation)anno.getValue()).getCoordinates().replace(), new Object[]{annotationArg});
                }
            }
            return (J.Annotation)anno.getValue();
        }

        private @Nullable String getAnnotationArgumentValueForMethodTemplate(J.Annotation anno) {
            String annotationArgumentValue = null;
            if (anno.getArguments() != null && anno.getArguments().size() == 1) {
                Expression annoArg = (Expression)anno.getArguments().get(0);
                if (annoArg instanceof J.Literal) {
                    annotationArgumentValue = (String)((J.Literal)annoArg).getValue();
                } else if (annoArg instanceof J.Assignment && ((J.Assignment)annoArg).getAssignment() instanceof J.Literal) {
                    annotationArgumentValue = (String)((J.Literal)((J.Assignment)annoArg).getAssignment()).getValue();
                }
            }
            if (this.initMethodReferences.containsKey(annotationArgumentValue)) {
                annotationArgumentValue = this.initMethodReferences.get(annotationArgumentValue);
            }
            if (annotationArgumentValue != null) {
                String[] methodRefs = annotationArgumentValue.split(",");
                if (methodRefs.length > 1) {
                    String methods = Arrays.stream(methodRefs).map(mref -> "\"" + mref + "\"").collect(Collectors.joining(", "));
                    annotationArgumentValue = "{" + methods + "}";
                } else {
                    annotationArgumentValue = "\"" + annotationArgumentValue + "\"";
                }
            }
            return annotationArgumentValue;
        }
    }
}

