/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.junit5.RunnerToExtension;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MockitoJUnitRunnerToExtension
extends Recipe {
    public String getDisplayName() {
        return "Replace JUnit 4 MockitoJUnitRunner with junit-jupiter MockitoExtension";
    }

    public String getDescription() {
        return "Replace JUnit 4 MockitoJUnitRunner annotations with JUnit 5 `@ExtendWith(MockitoExtension.class)` using the appropriate strictness levels (LENIENT, WARN, STRICT_STUBS).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.mockito.junit.MockitoJUnitRunner*", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final String runWith = "@org.junit.runner.RunWith";

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                AtomicReference strictness = new AtomicReference();
                new Annotated.Matcher("@org.junit.runner.RunWith").asVisitor((a, s) -> ((J.Annotation)a.getTree()).acceptJava((JavaVisitor)new JavaIsoVisitor<AtomicReference<Strictness>>(){

                    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, AtomicReference<Strictness> strictness) {
                        for (Strictness strict : Strictness.values()) {
                            if (!TypeUtils.isAssignableTo((String)strict.runner, (JavaType)fieldAccess.getTarget().getType())) continue;
                            strictness.set(strict);
                            break;
                        }
                        return fieldAccess;
                    }
                }, s)).visit((Tree)cd, strictness);
                if (strictness.get() == null) {
                    return cd;
                }
                this.registerAfterVisit();
                return this.getTemplate((Strictness)((Object)strictness.get()), ctx).map(t -> (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)((J.ClassDeclaration)t.apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0])), ctx)).orElse(cd);
            }

            private void registerAfterVisit() {
                this.doAfterVisit(new RunnerToExtension(Arrays.asList("org.mockito.junit.MockitoJUnitRunner.Silent", "org.mockito.junit.MockitoJUnitRunner.Strict", "org.mockito.junit.MockitoJUnitRunner"), "org.mockito.junit.jupiter.MockitoExtension").getVisitor());
                for (Strictness strictness : Strictness.values()) {
                    this.maybeRemoveImport(strictness.runner);
                }
                this.maybeAddImport("org.mockito.quality.Strictness");
                this.maybeAddImport("org.mockito.junit.jupiter.MockitoSettings");
            }

            private Optional<JavaTemplate> getTemplate(Strictness strictness, ExecutionContext ctx) {
                if (strictness == Strictness.STRICT_STUBS) {
                    return Optional.empty();
                }
                return Optional.of(JavaTemplate.builder((String)("@MockitoSettings(strictness = Strictness." + (Object)((Object)strictness) + ")")).imports(new String[]{"org.mockito.quality.Strictness", "org.mockito.junit.jupiter.MockitoSettings"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-junit-jupiter-3.12", "mockito-core-3.12"})).build());
            }
        });
    }

    private static enum Strictness {
        LENIENT("org.mockito.junit.MockitoJUnitRunner.Silent"),
        STRICT_STUBS("org.mockito.junit.MockitoJUnitRunner.Strict"),
        WARN("org.mockito.junit.MockitoJUnitRunner");

        final String runner;

        private Strictness(String runner) {
            this.runner = runner;
        }
    }
}

