/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.truth;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class TruthThrowableAssertions
extends Recipe {
    private static final MethodMatcher ASSERT_THAT = new MethodMatcher("com.google.common.truth.Truth assertThat(..)");
    private static final MethodMatcher HAS_MESSAGE_THAT = new MethodMatcher("com.google.common.truth.ThrowableSubject hasMessageThat()");
    private static final MethodMatcher HAS_CAUSE_THAT = new MethodMatcher("com.google.common.truth.ThrowableSubject hasCauseThat()");
    private static final MethodMatcher CONTAINS = new MethodMatcher("com.google.common.truth.StringSubject contains(..)");
    private static final MethodMatcher IS_EQUAL_TO = new MethodMatcher("com.google.common.truth.Subject isEqualTo(..)");
    private static final MethodMatcher IS_INSTANCE_OF = new MethodMatcher("com.google.common.truth.Subject isInstanceOf(..)");

    public String getDisplayName() {
        return "Convert Truth Throwable assertions to AssertJ";
    }

    public String getDescription() {
        return "Converts Google Truth's Throwable assertion chains like `hasMessageThat().contains()` to AssertJ equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(HAS_MESSAGE_THAT), new UsesMethod(HAS_CAUSE_THAT)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!(mi.getSelect() instanceof J.MethodInvocation)) {
                    return mi;
                }
                J.MethodInvocation hasMethod = (J.MethodInvocation)mi.getSelect();
                if (!ASSERT_THAT.matches(hasMethod.getSelect())) {
                    return mi;
                }
                J.MethodInvocation assertThat = (J.MethodInvocation)hasMethod.getSelect();
                if (CONTAINS.matches((MethodCall)mi) && HAS_MESSAGE_THAT.matches((MethodCall)hasMethod)) {
                    this.maybeRemoveImport("com.google.common.truth.Truth");
                    this.maybeRemoveImport("com.google.common.truth.Truth.assertThat");
                    this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).hasMessageContaining(#{any()})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{assertThat.getArguments().get(0), mi.getArguments().get(0)});
                }
                if (IS_EQUAL_TO.matches((MethodCall)mi) && HAS_MESSAGE_THAT.matches((MethodCall)hasMethod)) {
                    this.maybeRemoveImport("com.google.common.truth.Truth");
                    this.maybeRemoveImport("com.google.common.truth.Truth.assertThat");
                    this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).hasMessage(#{any()})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{assertThat.getArguments().get(0), mi.getArguments().get(0)});
                }
                if (IS_INSTANCE_OF.matches((MethodCall)mi) && HAS_CAUSE_THAT.matches((MethodCall)hasMethod)) {
                    this.maybeRemoveImport("com.google.common.truth.Truth");
                    this.maybeRemoveImport("com.google.common.truth.Truth.assertThat");
                    this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).hasCauseInstanceOf(#{any()})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{assertThat.getArguments().get(0), mi.getArguments().get(0)});
                }
                return mi;
            }
        });
    }
}

