/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitAssertNotEqualsToAssertThat
extends Recipe {
    private static final String JUNIT = "org.junit.jupiter.api.Assertions";
    private static final String ASSERTJ = "org.assertj.core.api.Assertions";
    private static final MethodMatcher ASSERT_NOT_EQUALS_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertNotEquals(..)", true);

    public String getDisplayName() {
        return "JUnit `assertNotEquals` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertNotEquals()` to AssertJ's `assertThat().isNotEqualTo()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_NOT_EQUALS_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_NOT_EQUALS_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                this.maybeRemoveImport(JUnitAssertNotEqualsToAssertThat.JUNIT);
                this.maybeAddImport(JUnitAssertNotEqualsToAssertThat.ASSERTJ, "assertThat", false);
                List args = mi.getArguments();
                Expression expected = (Expression)args.get(0);
                Expression actual = (Expression)args.get(1);
                if (args.size() == 2) {
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).isNotEqualTo(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{actual, expected});
                }
                if (args.size() == 3 && this.isFloatingPointType((Expression)args.get(2))) {
                    this.maybeAddImport(JUnitAssertNotEqualsToAssertThat.ASSERTJ, "within", false);
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).isNotCloseTo(#{any()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{actual, expected, args.get(2)});
                }
                if (args.size() == 3) {
                    Expression message = (Expression)args.get(2);
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any()}).isNotEqualTo(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{actual, message, expected});
                }
                this.maybeAddImport(JUnitAssertNotEqualsToAssertThat.ASSERTJ, "within", false);
                Expression message = (Expression)args.get(3);
                return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any()}).isNotCloseTo(#{any()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message, expected, args.get(2)});
            }

            private boolean isFloatingPointType(Expression expression) {
                JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)expression.getType());
                if (fullyQualified != null) {
                    String typeName = fullyQualified.getFullyQualifiedName();
                    return "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName);
                }
                JavaType.Primitive parameterType = TypeUtils.asPrimitive((JavaType)expression.getType());
                return parameterType == JavaType.Primitive.Double || parameterType == JavaType.Primitive.Float;
            }
        });
    }
}

