/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class JUnitAssertThrowsToAssertExceptionType
extends Recipe {
    private static final String JUNIT_ASSERTIONS = "org.junit.jupiter.api.Assertions";
    private static final String ASSERTIONS_FOR_CLASS_TYPES = "org.assertj.core.api.AssertionsForClassTypes";
    private static final MethodMatcher ASSERT_THROWS_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertThrows(..)");

    public String getDisplayName() {
        return "JUnit AssertThrows to AssertJ exceptionType";
    }

    public String getDescription() {
        return "Convert `JUnit#AssertThrows` to `AssertJ#assertThatExceptionOfType` to allow for chained assertions on the thrown exception.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_THROWS_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_THROWS_MATCHER.matches((MethodCall)mi)) {
                    return mi;
                }
                Optional<Boolean> hasReturnType = this.hasReturnType();
                if (!hasReturnType.isPresent()) {
                    return mi;
                }
                boolean returnActual = hasReturnType.get();
                this.maybeRemoveImport(JUnitAssertThrowsToAssertExceptionType.JUNIT_ASSERTIONS);
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrows");
                this.maybeAddImport(JUnitAssertThrowsToAssertExceptionType.ASSERTIONS_FOR_CLASS_TYPES, "assertThatExceptionOfType");
                List args = mi.getArguments();
                if (args.size() == 2) {
                    String code = "assertThatExceptionOfType(#{any(java.lang.Class)}).isThrownBy(#{any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})";
                    if (returnActual) {
                        code = code + ".actual()";
                    }
                    return (J.MethodInvocation)JavaTemplate.builder((String)code).staticImports(new String[]{"org.assertj.core.api.AssertionsForClassTypes.assertThatExceptionOfType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{args.get(0), args.get(1)});
                }
                String code = "assertThatExceptionOfType(#{any()}).as(#{any()}).isThrownBy(#{any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})";
                if (returnActual) {
                    code = code + ".actual()";
                }
                return (J.MethodInvocation)JavaTemplate.builder((String)code).staticImports(new String[]{"org.assertj.core.api.AssertionsForClassTypes.assertThatExceptionOfType"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{args.get(0), args.get(2), args.get(1)});
            }

            private Optional<Boolean> hasReturnType() {
                Object parent = this.getCursor().getParentTreeCursor().getValue();
                if (parent instanceof J.Assignment || parent instanceof J.VariableDeclarations || parent instanceof J.VariableDeclarations.NamedVariable || parent instanceof J.Return || parent instanceof J.Ternary) {
                    return Optional.of(true);
                }
                if (parent instanceof J.Block) {
                    return Optional.of(false);
                }
                return Optional.empty();
            }
        });
    }
}

