/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class TestMethodsShouldBeVoid
extends Recipe {
    private static final String TEST_ANNOTATION_TYPE_PATTERN = "org..*Test";

    public String getDisplayName() {
        return "Test methods should have void return type";
    }

    public String getDescription() {
        return "Test methods annotated with `@Test`, `@ParameterizedTest`, `@RepeatedTest`, `@TestTemplate` should have `void` return type. Non-void return types can cause test discovery issues, and warnings as of JUnit 5.13+. This recipe changes the return type to `void` and removes `return` statements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(TEST_ANNOTATION_TYPE_PATTERN, Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (!TestMethodsShouldBeVoid.hasJUnit5MethodAnnotation(m)) {
                    return m;
                }
                JavaType.Primitive voidType = JavaType.Primitive.Void;
                if (m.getReturnTypeExpression() == null || TypeUtils.isOfType((JavaType)m.getReturnTypeExpression().getType(), (JavaType)voidType)) {
                    return m;
                }
                if ((m = m.withReturnTypeExpression((TypeTree)new J.Primitive(m.getReturnTypeExpression().getId(), m.getReturnTypeExpression().getPrefix(), m.getReturnTypeExpression().getMarkers(), voidType))).getMethodType() != null) {
                    m = m.withMethodType(m.getMethodType().withReturnType((JavaType)voidType));
                }
                return m.withBody((J.Block)new RemoveDirectReturns().visitBlock(Objects.requireNonNull(m.getBody()), ctx));
            }
        });
    }

    private static boolean hasJUnit5MethodAnnotation(J.MethodDeclaration method) {
        for (J.Annotation a : method.getLeadingAnnotations()) {
            if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.Test") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.RepeatedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.params.ParameterizedTest") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestFactory") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.jupiter.api.TestTemplate")) continue;
            return true;
        }
        return false;
    }

    private static class RemoveDirectReturns
    extends JavaVisitor<ExecutionContext> {
        private RemoveDirectReturns() {
        }

        public J visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            return lambda;
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            return newClass;
        }

        public @Nullable J visitReturn(J.Return retrn, ExecutionContext ctx) {
            return retrn.getExpression() instanceof Statement ? retrn.getExpression().withPrefix(retrn.getPrefix()) : null;
        }
    }
}

