/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.testing.junit5.AddNewFolderOrFileMethod;
import org.openrewrite.java.testing.junit5.FileOrFolder;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

class TemporaryFolderToTempDirVisitor
extends JavaVisitor<ExecutionContext> {
    private static final String TEMPORARY_FOLDER = "org.junit.rules.TemporaryFolder";
    private static final String TEMP_DIR = "org.junit.jupiter.api.io.TempDir";
    private static final AnnotationMatcher CLASS_RULE = new AnnotationMatcher("@org.junit.ClassRule");
    private static final AnnotationMatcher RULE = new AnnotationMatcher("@org.junit.Rule");
    private static final MethodMatcher NEW_TEMPORARY_FOLDER = new MethodMatcher("org.junit.rules.TemporaryFolder <init>()");
    private static final MethodMatcher NEW_TEMPORARY_FOLDER_WITH_ARG = new MethodMatcher("org.junit.rules.TemporaryFolder <init>(java.io.File)");

    TemporaryFolderToTempDirVisitor() {
    }

    public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
        J.CompilationUnit c = (J.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
        if (c != cu) {
            c = (J.CompilationUnit)new ChangeType(TEMPORARY_FOLDER, "java.io.File", Boolean.valueOf(true)).getVisitor().visit((Tree)c, (Object)ctx);
            this.maybeRemoveImport("org.junit.ClassRule");
            this.maybeRemoveImport("org.junit.Rule");
            this.maybeRemoveImport(TEMPORARY_FOLDER);
            this.maybeAddImport("java.io.File");
            this.maybeAddImport("java.nio.file.Files");
            this.maybeAddImport(TEMP_DIR);
        }
        return c;
    }

    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
        J.VariableDeclarations mv = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)ctx);
        if (!TypeUtils.isOfClassType((JavaType)multiVariable.getTypeAsFullyQualified(), (String)TEMPORARY_FOLDER)) {
            return mv;
        }
        mv = mv.withTypeExpression((TypeTree)this.toFileIdentifier(mv.getTypeExpression()));
        return (J.VariableDeclarations)new Annotated.Matcher("@org.junit.*Rule").asVisitor(a -> JavaTemplate.builder((String)"@TempDir").imports(new String[]{TEMP_DIR}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(a.getCursor(), ((J.Annotation)a.getTree()).getCoordinates().replace(), new Object[0])).visitNonNull((Tree)mv, (Object)ctx, this.getCursor().getParentOrThrow());
    }

    public @Nullable J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
        if (NEW_TEMPORARY_FOLDER.matches((MethodCall)newClass)) {
            return this.hasRuleAnnotation() ? null : JavaTemplate.builder((String)"Files.createTempDirectory(\"junit\").toFile()").imports(new String[]{"java.nio.file.Files"}).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[0]);
        }
        if (NEW_TEMPORARY_FOLDER_WITH_ARG.matches((MethodCall)newClass)) {
            return this.hasRuleAnnotation() ? null : JavaTemplate.builder((String)"Files.createTempDirectory(#{any(java.io.File)}.toPath(), \"junit\").toFile()").imports(new String[]{"java.nio.file.Files"}).build().apply(this.getCursor(), newClass.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
        }
        return super.visitNewClass(newClass, (Object)ctx);
    }

    public @Nullable J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
        this.updateCursor((Tree)mi);
        if (mi.getSelect() != null && mi.getMethodType() != null && TypeUtils.isOfClassType((JavaType)mi.getMethodType().getDeclaringType(), (String)TEMPORARY_FOLDER)) {
            switch (mi.getSimpleName()) {
                case "newFile": {
                    return this.convertToNewFile(mi, ctx);
                }
                case "newFolder": {
                    this.doAfterVisit((TreeVisitor)new AddNewFolderOrFileMethod(mi, FileOrFolder.FOLDER, (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class)));
                    break;
                }
                case "create": {
                    return null;
                }
                case "getRoot": {
                    return mi.getSelect().withPrefix(mi.getPrefix());
                }
                default: {
                    return mi;
                }
            }
        }
        return mi;
    }

    private J.Identifier toFileIdentifier(TypeTree typeTree) {
        JavaType.ShallowClass fileType = JavaType.ShallowClass.build((String)"java.io.File");
        return new J.Identifier(Tree.randomId(), typeTree.getPrefix(), Markers.EMPTY, Collections.emptyList(), fileType.getClassName(), (JavaType)fileType, null);
    }

    private boolean hasRuleAnnotation() {
        J.VariableDeclarations vd = (J.VariableDeclarations)this.getCursor().firstEnclosing(J.VariableDeclarations.class);
        if (vd == null) {
            return false;
        }
        return vd.getLeadingAnnotations().stream().anyMatch(anno -> CLASS_RULE.matches(anno) || RULE.matches(anno));
    }

    private J convertToNewFile(J.MethodInvocation mi, ExecutionContext ctx) {
        if (mi.getSelect() == null) {
            return mi;
        }
        List args = mi.getArguments().stream().filter(arg -> !(arg instanceof J.Empty)).collect(Collectors.toList());
        if (args.isEmpty()) {
            J tempDir = mi.getSelect().withType((JavaType)JavaType.ShallowClass.build((String)"java.io.File"));
            return JavaTemplate.builder((String)"File.createTempFile(\"junit\", null, #{any(java.io.File)})").imports(new String[]{"java.io.File"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{tempDir});
        }
        this.doAfterVisit((TreeVisitor)new AddNewFolderOrFileMethod(mi, FileOrFolder.FILE, (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class)));
        return mi;
    }
}

