/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dependencies.DependencyInsight;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class VerifyZeroToNoMoreInteractions
extends ScanningRecipe<AtomicBoolean> {
    private static final String VERIFY_ZERO_INTERACTIONS = "org.mockito.Mockito verifyZeroInteractions(..)";
    private static final MethodMatcher ASSERT_INSTANCE_OF_MATCHER = new MethodMatcher("org.mockito.Mockito verifyZeroInteractions(..)", true);

    public String getDisplayName() {
        return "Replace `verifyZeroInteractions()` with `verifyNoMoreInteractions()`";
    }

    public String getDescription() {
        return "Replaces `verifyZeroInteractions()` with `verifyNoMoreInteractions()` in Mockito tests when migration when using a Mockito version < 3.x.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean usingOlderMockito) {
        final TreeVisitor div = new DependencyInsight("org.mockito", "mockito-*", "[1.0,3.0)", null).getVisitor();
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!usingOlderMockito.get() && div.visit(tree, (Object)ctx) != tree) {
                    usingOlderMockito.set(true);
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean usingOlderMockito) {
        return Preconditions.check((boolean)usingOlderMockito.get(), (TreeVisitor)Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_INSTANCE_OF_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation md = super.visitMethodInvocation(method, (Object)ctx);
                if (!ASSERT_INSTANCE_OF_MATCHER.matches((MethodCall)md)) {
                    return md;
                }
                this.maybeRemoveImport("org.mockito.Mockito.verifyZeroInteractions");
                this.maybeAddImport("org.mockito.Mockito", "verifyNoMoreInteractions");
                ChangeMethodName changeMethodName = new ChangeMethodName(VerifyZeroToNoMoreInteractions.VERIFY_ZERO_INTERACTIONS, "verifyNoMoreInteractions", Boolean.valueOf(false), Boolean.valueOf(false));
                return (J.MethodInvocation)changeMethodName.getVisitor().visitNonNull((Tree)md, (Object)ctx);
            }
        }));
    }
}

