/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.testcontainers;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ConvertToRawType
extends Recipe {
    @Option(displayName="Fully qualified type name", description="The fully qualified name of the Java class to convert to its raw type.", example="org.testcontainers.containers.PostgreSQLContainer")
    private final String fullyQualifiedTypeName;

    public String getDisplayName() {
        return "Remove parameterized type arguments from a Java class";
    }

    public String getDescription() {
        return "Convert parameterized types of a specified Java class to their raw types.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(this.fullyQualifiedTypeName, Boolean.valueOf(false)), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public @Nullable JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
                if (javaType instanceof JavaType.Parameterized) {
                    JavaType.FullyQualified rawType = ((JavaType.Parameterized)javaType).getType();
                    if (TypeUtils.isAssignableTo((String)ConvertToRawType.this.fullyQualifiedTypeName, (JavaType)rawType)) {
                        return rawType;
                    }
                }
                return super.visitType(javaType, (Object)ctx);
            }

            public J visitParameterizedType(J.ParameterizedType type, ExecutionContext ctx) {
                J.ParameterizedType pt = (J.ParameterizedType)super.visitParameterizedType(type, (Object)ctx);
                if (TypeUtils.isAssignableTo((String)ConvertToRawType.this.fullyQualifiedTypeName, (JavaType)pt.getType())) {
                    return ((J.Identifier)pt.getClazz()).withPrefix(pt.getPrefix()).withType(pt.getType());
                }
                return pt;
            }
        });
    }

    @ConstructorProperties(value={"fullyQualifiedTypeName"})
    @Generated
    public ConvertToRawType(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    @Generated
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ConvertToRawType(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertToRawType)) {
            return false;
        }
        ConvertToRawType other = (ConvertToRawType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ConvertToRawType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }
}

