/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.gradle8;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class JacocoReportDeprecations
extends Recipe {
    private static final String JACOCO_SETTINGS_INDEX = "JACOCO_SETTINGS_INDEX";

    public String getDisplayName() {
        return "Replace Gradle 8 introduced deprecations in JaCoCo report task";
    }

    public String getDescription() {
        return "Set the `enabled` to `required` and the `destination` to `outputLocation` for Reports deprecations that were removed in gradle 8. See [the gradle docs on this topic](https://docs.gradle.org/current/userguide/upgrading_version_7.html#report_and_testreport_api_cleanup).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
                Integer index = (Integer)this.getCursor().getNearestMessage(JacocoReportDeprecations.JACOCO_SETTINGS_INDEX);
                if (index == null) {
                    index = 0;
                } else {
                    Integer n = index;
                    index = index + 1;
                }
                if (assignment.getVariable() instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)assignment.getVariable();
                    String fieldName = this.getFieldName(fieldAccess);
                    return this.replaceDeprecations(assignment, index, fieldName);
                }
                if (assignment.getVariable() instanceof J.Identifier) {
                    J.Identifier identifier = (J.Identifier)assignment.getVariable();
                    return this.replaceDeprecations(assignment, index, identifier.getSimpleName());
                }
                return assignment;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                Integer parent = (Integer)this.getCursor().getNearestMessage(JacocoReportDeprecations.JACOCO_SETTINGS_INDEX);
                if (parent == null) {
                    parent = 0;
                } else {
                    Integer n = parent;
                    parent = parent + 1;
                }
                if (!method.getArguments().isEmpty()) {
                    J.MethodInvocation replacement;
                    boolean shouldReplace = false;
                    if (parent == 2 && method.getSelect() instanceof J.Identifier) {
                        J.Identifier select = (J.Identifier)method.getSelect();
                        shouldReplace = this.isReportType(select.getSimpleName());
                    } else if (parent == 1 && method.getSelect() instanceof J.FieldAccess) {
                        J.FieldAccess selectField = (J.FieldAccess)method.getSelect();
                        if (selectField.getTarget() instanceof J.Identifier) {
                            J.Identifier target = (J.Identifier)selectField.getTarget();
                            shouldReplace = "reports".equalsIgnoreCase(target.getSimpleName()) && this.isReportType(selectField.getSimpleName());
                        }
                    } else if (parent == 3 && method.getSelect() == null) {
                        shouldReplace = true;
                    }
                    if (shouldReplace && (replacement = this.replaceDeprecatedMethodName(method)) != method) {
                        return replacement;
                    }
                }
                if (this.isPartOfDeprecatedPath(method.getSimpleName(), parent)) {
                    this.getCursor().putMessage(JacocoReportDeprecations.JACOCO_SETTINGS_INDEX, (Object)parent);
                    return super.visitMethodInvocation(method, (Object)ctx);
                }
                return method;
            }

            private boolean isReportType(String name) {
                return "xml".equalsIgnoreCase(name) || "csv".equalsIgnoreCase(name) || "html".equalsIgnoreCase(name);
            }

            private J.MethodInvocation replaceDeprecatedMethodName(J.MethodInvocation method) {
                String methodName = method.getSimpleName();
                if ("enabled".equalsIgnoreCase(methodName) || "isEnabled".equalsIgnoreCase(methodName) || "setEnabled".equalsIgnoreCase(methodName)) {
                    return method.withName(method.getName().withSimpleName("required"));
                }
                if ("destination".equalsIgnoreCase(methodName) || "setDestination".equalsIgnoreCase(methodName)) {
                    return method.withName(method.getName().withSimpleName("outputLocation"));
                }
                return method;
            }

            private J.Assignment replaceDeprecations(J.Assignment assignment, int index, String path) {
                if (this.isDeprecatedPath(path, index)) {
                    String field = path.substring(path.lastIndexOf(".") + 1);
                    if (assignment.getVariable() instanceof J.FieldAccess) {
                        J.FieldAccess fieldAccess = (J.FieldAccess)assignment.getVariable();
                        if ("enabled".equalsIgnoreCase(field) || "isEnabled".equalsIgnoreCase(field)) {
                            return assignment.withVariable((Expression)fieldAccess.withName(fieldAccess.getName().withSimpleName("required")));
                        }
                        if ("destination".equalsIgnoreCase(field)) {
                            return assignment.withVariable((Expression)fieldAccess.withName(fieldAccess.getName().withSimpleName("outputLocation")));
                        }
                    } else if (assignment.getVariable() instanceof J.Identifier) {
                        J.Identifier identifier = (J.Identifier)assignment.getVariable();
                        if ("enabled".equalsIgnoreCase(field) || "isEnabled".equalsIgnoreCase(field)) {
                            return assignment.withVariable((Expression)identifier.withSimpleName("required"));
                        }
                        if ("destination".equalsIgnoreCase(field)) {
                            return assignment.withVariable((Expression)identifier.withSimpleName("outputLocation"));
                        }
                    }
                }
                return assignment;
            }

            private boolean isPartOfDeprecatedPath(String path, int index) {
                if (StringUtils.isNullOrEmpty((String)path)) {
                    return false;
                }
                switch (index) {
                    case 0: {
                        return "jacocoTestReport".equalsIgnoreCase(path);
                    }
                    case 1: {
                        return "reports".equalsIgnoreCase(path);
                    }
                    case 2: {
                        return "xml".equalsIgnoreCase(path) || "csv".equalsIgnoreCase(path) || "html".equalsIgnoreCase(path);
                    }
                    case 3: {
                        return "enabled".equalsIgnoreCase(path) || "isEnabled".equalsIgnoreCase(path) || "destination".equalsIgnoreCase(path);
                    }
                }
                return false;
            }

            private boolean isDeprecatedPath(String path, int index) {
                if (StringUtils.isNullOrEmpty((String)path)) {
                    return false;
                }
                String[] parts = path.split("\\.");
                for (int i = 0; i < parts.length; ++i) {
                    if (this.isPartOfDeprecatedPath(parts[i], index + i)) continue;
                    return false;
                }
                return true;
            }

            private String getFieldName(J.FieldAccess fieldAccess) {
                String fieldName = fieldAccess.getSimpleName();
                J.FieldAccess target = fieldAccess;
                while (target instanceof J.FieldAccess) {
                    if ((target = target.getTarget()) instanceof J.Identifier) {
                        fieldName = ((J.Identifier)target).getSimpleName() + "." + fieldName;
                        continue;
                    }
                    if (!(target instanceof J.FieldAccess)) continue;
                    fieldName = target.getSimpleName() + "." + fieldName;
                }
                return fieldName;
            }
        });
    }

    @Generated
    public JacocoReportDeprecations() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "JacocoReportDeprecations()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacocoReportDeprecations)) {
            return false;
        }
        JacocoReportDeprecations other = (JacocoReportDeprecations)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JacocoReportDeprecations;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

