/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.search.FindRepository;
import org.openrewrite.groovy.format.AutoFormat;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;

public final class AddSettingsPluginRepository
extends Recipe {
    @Option(displayName="Type", description="The type of the artifact repository", example="maven")
    private final String type;
    @Option(displayName="URL", description="The url of the artifact repository", required=false, example="https://repo.spring.io")
    private final @Nullable String url;

    public String getDisplayName() {
        return "Add a Gradle settings repository";
    }

    public String getDescription() {
        return "Add a Gradle settings repository to `settings.gradle(.kts)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile && tree == new FindRepository(AddSettingsPluginRepository.this.type, AddSettingsPluginRepository.this.url, FindRepository.Purpose.Plugin).getVisitor().visit(tree, (Object)ctx)) {
                    if (tree instanceof G.CompilationUnit) {
                        return this.visitCompilationUnit((G.CompilationUnit)tree, ctx);
                    }
                    if (tree instanceof K.CompilationUnit) {
                        return this.visitCompilationUnit((K.CompilationUnit)tree, ctx);
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit g, ExecutionContext ctx) {
                J.MethodInvocation pluginManagement = (J.MethodInvocation)this.generatePluginManagementBlock(G.CompilationUnit.class, cu -> (J)cu.getStatements().get(0), ctx);
                ArrayList<Statement> statements = new ArrayList<Statement>(g.getStatements());
                if (statements.isEmpty()) {
                    statements.add((Statement)pluginManagement);
                } else {
                    this.addPluginManagementRepos(statements, (J)pluginManagement);
                }
                return (G.CompilationUnit)new AutoFormat().getVisitor().visitNonNull((Tree)g.withStatements(statements), (Object)ctx);
            }

            public K.CompilationUnit visitCompilationUnit(K.CompilationUnit k, ExecutionContext ctx) {
                J.Block pluginManagement = (J.Block)this.generatePluginManagementBlock(K.CompilationUnit.class, cu -> (J)cu.getStatements().get(0), ctx);
                ArrayList<J.Block> statements = new ArrayList<J.Block>(k.getStatements());
                if (statements.isEmpty()) {
                    statements.addAll(pluginManagement.getStatements());
                } else {
                    Statement blockStatement = (Statement)statements.get(0);
                    if (blockStatement instanceof J.Block) {
                        J.Block b = (J.Block)blockStatement;
                        ArrayList<Statement> blockStatements = new ArrayList<Statement>(b.getStatements());
                        if (blockStatements.isEmpty()) {
                            statements.addAll(pluginManagement.getStatements());
                        } else {
                            statements.set(0, b.withStatements(this.addPluginManagementRepos(blockStatements, (J)pluginManagement)));
                        }
                    }
                }
                return (K.CompilationUnit)new AutoFormat().getVisitor().visitNonNull((Tree)k.withStatements(statements), (Object)ctx);
            }

            private List<Statement> addPluginManagementRepos(List<Statement> statements, J pluginManagement) {
                Statement statement = statements.get(0);
                if (statement instanceof J.MethodInvocation && "pluginManagement".equals(((J.MethodInvocation)statement).getSimpleName())) {
                    J.MethodInvocation m = (J.MethodInvocation)statement;
                    m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                        if (arg instanceof J.Lambda && ((J.Lambda)arg).getBody() instanceof J.Block) {
                            J.Lambda lambda = (J.Lambda)arg;
                            J.Block block = (J.Block)lambda.getBody();
                            return lambda.withBody((J)block.withStatements(ListUtils.map((List)block.getStatements(), statement2 -> {
                                if (statement2 instanceof J.MethodInvocation && "repositories".equals(((J.MethodInvocation)statement2).getSimpleName()) || statement2 instanceof J.Return && ((J.Return)statement2).getExpression() instanceof J.MethodInvocation && "repositories".equals(((J.MethodInvocation)((J.Return)statement2).getExpression()).getSimpleName())) {
                                    J.MethodInvocation m2 = (J.MethodInvocation)(statement2 instanceof J.Return ? ((J.Return)statement2).getExpression() : statement2);
                                    m2 = m2.withArguments(ListUtils.mapFirst((List)m2.getArguments(), arg2 -> {
                                        if (arg2 instanceof J.Lambda && ((J.Lambda)arg2).getBody() instanceof J.Block) {
                                            J.Lambda lambda2 = (J.Lambda)arg2;
                                            J.Block block2 = (J.Block)lambda2.getBody();
                                            Statement lastStatement = (Statement)block2.getStatements().get(block2.getStatements().size() - 1);
                                            return lambda2.withBody((J)block2.withStatements(ListUtils.concat((List)ListUtils.mapLast((List)block2.getStatements(), s -> s instanceof J.Return ? (Statement)((J.Return)s).getExpression().withPrefix(lastStatement.getPrefix()) : s), (Object)((Statement)(lastStatement instanceof J.Return ? ((J.Return)lastStatement).withExpression((Expression)this.extractRepository(pluginManagement).withPrefix(Space.EMPTY)) : this.extractRepository(pluginManagement).withPrefix(lastStatement.getPrefix())).withComments(Collections.emptyList())))));
                                        }
                                        return arg2;
                                    }));
                                    if (statement2 instanceof J.Return) {
                                        return ((J.Return)statement2).withExpression((Expression)m2);
                                    }
                                    return m2;
                                }
                                return statement2;
                            })));
                        }
                        return arg;
                    }));
                    statements.set(0, (Statement)m);
                } else {
                    J.MethodInvocation pluginManagementStatement = pluginManagement instanceof J.Block ? (Statement)((J.Block)pluginManagement).getStatements().get(0) : (J.MethodInvocation)pluginManagement;
                    statements.add(0, (Statement)pluginManagementStatement);
                    statements.set(1, (Statement)statements.get(1).withPrefix(Space.format((String)"\n\n")));
                }
                return statements;
            }

            private <T extends JavaSourceFile> J generatePluginManagementBlock(Class<T> compilationUnitClass, Function<T, J> methodExtractor, ExecutionContext ctx) {
                String code = AddSettingsPluginRepository.this.url == null ? "pluginManagement {\n    repositories {\n        " + AddSettingsPluginRepository.this.type + "()\n    }\n}" : (G.class.isAssignableFrom(compilationUnitClass) ? "pluginManagement {\n    repositories {\n        " + AddSettingsPluginRepository.this.type + " {\n            url = \"" + AddSettingsPluginRepository.this.url + "\"\n        }\n    }\n}" : "pluginManagement {\n    repositories {\n        " + AddSettingsPluginRepository.this.type + " {\n            url = uri(\"" + AddSettingsPluginRepository.this.url + "\")\n        }\n    }\n}");
                Path path = Paths.get("settings" + (G.class.isAssignableFrom(compilationUnitClass) ? ".gradle" : ".gradle.kts"), new String[0]);
                return methodExtractor.apply((JavaSourceFile)GradleParser.builder().build().parseInputs(Collections.singletonList(Parser.Input.fromString((Path)path, (String)code)), null, ctx).map(compilationUnitClass::cast).collect(Collectors.toList()).get(0));
            }

            private J.MethodInvocation extractRepository(J j) {
                J.MethodInvocation pluginManagement = j instanceof J.MethodInvocation ? (J.MethodInvocation)j : (J.MethodInvocation)((J.Block)j).getStatements().get(0);
                J mi = (J)((J.Block)((J.Lambda)pluginManagement.getArguments().get(0)).getBody()).getStatements().get(0);
                if (mi instanceof J.Return) {
                    mi = ((J.Return)mi).getExpression().withPrefix(mi.getPrefix());
                }
                if ((mi = (J)((J.Block)((J.Lambda)Objects.requireNonNull((J.MethodInvocation)mi).getArguments().get(0)).getBody()).getStatements().get(0)) instanceof J.Return) {
                    mi = ((J.Return)mi).getExpression().withPrefix(mi.getPrefix());
                }
                return (J.MethodInvocation)mi;
            }
        });
    }

    @Generated
    public AddSettingsPluginRepository(String type, @Nullable String url) {
        this.type = type;
        this.url = url;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public @Nullable String getUrl() {
        return this.url;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddSettingsPluginRepository(type=" + this.getType() + ", url=" + this.getUrl() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSettingsPluginRepository)) {
            return false;
        }
        AddSettingsPluginRepository other = (AddSettingsPluginRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddSettingsPluginRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

